/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.tunnel.AbstractTunnel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BufferTunnel<T>
extends AbstractTunnel<T> {
    private static int DEFAULT_BUFFER_SIZE = 10;
    private LinkedBlockingQueue<T> buffer = null;

    public BufferTunnel(JobMeta jobMeta) {
        this(jobMeta, DEFAULT_BUFFER_SIZE);
    }

    public BufferTunnel(JobMeta jobMeta, int defaultSize) {
        super(jobMeta);
        this.buffer = new LinkedBlockingQueue(defaultSize);
    }

    @Override
    public void putInternal(T t) throws InterruptedException {
        this.buffer.put(t);
    }

    @Override
    public T takeInternal() throws InterruptedException {
        T ret;
        do {
            ret = this.buffer.poll(1L, TimeUnit.SECONDS);
        } while (!this.isProducerEmpty() && ret == null);
        return ret;
    }

    protected boolean isFinished() {
        return this.isProducerEmpty() && this.buffer.isEmpty();
    }
}

