/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.common.util.TimeClicker;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.tunnel.BufferTunnel;
import com.oceanbase.tools.migrator.core.tunnel.limiter.AbstractRateLimiter;

public class TransRowsTunnel
extends BufferTunnel<TransRows> {
    private AbstractRateLimiter putRowRateLimiter = null;
    private AbstractRateLimiter putSizeRateLimiter = null;
    private AbstractRateLimiter takeRowRateLimiter = null;
    private AbstractRateLimiter takeSizeRateLimiter = null;

    public TransRowsTunnel(JobMeta jobMeta) {
        super(jobMeta);
    }

    @Override
    public void putInternal(TransRows rows) throws InterruptedException {
        TimeClicker clicker = new TimeClicker();
        super.putInternal(rows);
        this.getJobMeta().getJobStat().addPutWaitTimeUs(clicker.click());
        if (this.putRowRateLimiter != null) {
            clicker.click();
            this.putRowRateLimiter.acquire(rows.getReadRowCount());
            this.getJobMeta().getJobStat().addPutRowLimitWaitTimeUs(clicker.click());
        }
        if (this.putSizeRateLimiter != null) {
            clicker.click();
            int dataSizeKb = (int)rows.getDataSize() / 1024;
            if (dataSizeKb <= 0) {
                dataSizeKb = 1;
            }
            this.putSizeRateLimiter.acquire(dataSizeKb);
            this.getJobMeta().getJobStat().addPutSizeLimitWaitTimeUs(clicker.click());
        }
        this.getJobMeta().getJobStat().incPutTimes();
    }

    @Override
    public TransRows takeInternal() throws InterruptedException {
        TransRows rows = null;
        TimeClicker clicker = new TimeClicker();
        rows = (TransRows)super.takeInternal();
        this.getJobMeta().getJobStat().addTakeWaitTimeUs(clicker.click());
        if (rows != null) {
            if (this.takeRowRateLimiter != null) {
                clicker.click();
                this.takeRowRateLimiter.acquire(rows.getReadRowCount());
                this.getJobMeta().getJobStat().addTaskRowLimitWaitTimeUs(clicker.click());
            }
            if (this.takeSizeRateLimiter != null) {
                clicker.click();
                int dataSizeKb = (int)rows.getDataSize() / 1024;
                if (dataSizeKb <= 0) {
                    dataSizeKb = 1;
                }
                this.takeSizeRateLimiter.acquire(dataSizeKb);
                this.getJobMeta().getJobStat().addTaskSizeLimitWaitTimeUs(clicker.click());
            }
        }
        this.getJobMeta().getJobStat().incTakeTimes();
        return rows;
    }

    public void setPutRowRateLimiter(AbstractRateLimiter putRowRateLimiter) {
        this.putRowRateLimiter = putRowRateLimiter;
    }

    public void setPutSizeRateLimiter(AbstractRateLimiter putSizeRateLimiter) {
        this.putSizeRateLimiter = putSizeRateLimiter;
    }

    public void setTakeRowRateLimiter(AbstractRateLimiter takeRowRateLimiter) {
        this.takeRowRateLimiter = takeRowRateLimiter;
    }

    public void setTakeSizeRateLimiter(AbstractRateLimiter takeSizeRateLimiter) {
        this.takeSizeRateLimiter = takeSizeRateLimiter;
    }

    public AbstractRateLimiter getPutRowRateLimiter() {
        return this.putRowRateLimiter;
    }

    public AbstractRateLimiter getPutSizeRateLimiter() {
        return this.putSizeRateLimiter;
    }

    public AbstractRateLimiter getTakeRowRateLimiter() {
        return this.takeRowRateLimiter;
    }

    public AbstractRateLimiter getTakeSizeRateLimiter() {
        return this.takeSizeRateLimiter;
    }

    public void updateRateLimit() {
    }
}

