/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.dto.JobStatistic;
import com.oceanbase.tools.migrator.common.exception.JobStatisticNotFoundException;
import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class HistoryJobStatisticDao {
    private static final String SAVE_JOB_STATISTIC_SQL = "REPLACE INTO history_job_statistic(job_id, data_size, row_count, data_size_ps, row_count_ps, avg_put_wait_time_us, avg_take_wait_time_us, unmatched_row_count, read_row_count, read_row_count_ps, total_row_count, cpu_limit, mem_limit) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    private static final String QUERY_JOB_STATISTIC_SQL = "SELECT job_id, data_size, row_count, data_size_ps, row_count_ps, avg_put_wait_time_us,    avg_take_wait_time_us, unmatched_row_count, read_row_count, read_row_count_ps, total_row_count FROM  history_job_statistic WHERE job_id = ?";

    public static void saveJobStatistic(Connection connection, JobStatistic jobStatistic) throws SQLException {
        Object[] sqlParam = new Object[]{jobStatistic.getJobId(), jobStatistic.getDataSize(), jobStatistic.getRowCount(), jobStatistic.getDataSizePs(), jobStatistic.getRowCountPs(), jobStatistic.getAvgPutWaitTimeUs(), jobStatistic.getAvgTakeWaitTimeUs(), jobStatistic.getUnmatchedRowCount(), jobStatistic.getReadRowCount(), jobStatistic.getReadRowCountPs(), jobStatistic.getTotalRowCount(), jobStatistic.getCpuLimit(), jobStatistic.getMemLimit()};
        DaoUtils.update(connection, SAVE_JOB_STATISTIC_SQL, sqlParam);
    }

    public static JobStatistic queryJobStatistic(Connection connection, String taskGeneratorId) throws SQLException, JobStatisticNotFoundException {
        List<Map<String, Object>> result = DaoUtils.query(connection, QUERY_JOB_STATISTIC_SQL, taskGeneratorId);
        if (result.isEmpty()) {
            throw new JobStatisticNotFoundException(taskGeneratorId);
        }
        return new JobStatistic(result.get(0));
    }
}

