/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.util.DaoUtils;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TaskDao {
    private static final String BATCH_QUERY_TASKS_SQL = "SELECT job_id,task_index, pk_min,pk_max,task_status,pk_cursor,partition_name from task where job_id = ? and task_status <> 'SUCCESS'";
    private static final String QUERY_ABNORMAL_TASK_INDEX_SQL = "SELECT task_index FROM task WHERE job_id = ? and (task_status <> 'SUCCESS' or pk_cursor is null)";
    private static final String SAVE_TASK_SQL = "REPLACE INTO TASK (job_id, task_index, task_status, pk_min, pk_max, pk_cursor, partition_name) values(?, ?, ?, ?, ?, ?, ?)";

    public static List<TaskMeta> batchQueryTasks(Connection connection, JobMeta jobMeta) throws SQLException {
        List<Map<String, Object>> result = DaoUtils.query(connection, BATCH_QUERY_TASKS_SQL, jobMeta.getJobId());
        return result.stream().map(o -> new TaskMeta((Map<String, Object>)o, jobMeta)).collect(Collectors.toList());
    }

    public static Long queryAbnormalTaskIndex(Connection connection, String jobId) throws SQLException {
        List<Map<String, Object>> result = DaoUtils.query(connection, QUERY_ABNORMAL_TASK_INDEX_SQL, jobId);
        if (result.isEmpty()) {
            return null;
        }
        return (Long)result.get(0).get("task_index");
    }

    public static void saveTask(Connection connection, TaskMeta taskMeta) throws SQLException {
        Object[] sqlParam = new Object[]{taskMeta.getJobMeta().getJobId(), taskMeta.getTaskIndex(), taskMeta.getTaskStatus().name(), taskMeta.getMinPrimaryKey() == null ? null : taskMeta.getMinPrimaryKey().toSqlString(), taskMeta.getMaxPrimaryKey() == null ? null : taskMeta.getMaxPrimaryKey().toSqlString(), taskMeta.getCursorPrimaryKey() == null ? null : taskMeta.getCursorPrimaryKey().toSqlString(), taskMeta.getPartitionName()};
        DaoUtils.update(connection, SAVE_TASK_SQL, sqlParam);
    }
}

