/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.ExceptionSorter;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.util.VersionUtil;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObOracleExceptionSorter;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObDataSourceAdapter
extends AbstractDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractObDataSourceAdapter.class);
    private long lastWriteValidTime = 0L;
    private long lastDeleteValidTime = 0L;
    private int sleepTime = 50;
    public String obVersion;

    public AbstractObDataSourceAdapter(DataSourceInfo dataSourceInfo) {
        super(dataSourceInfo);
    }

    protected abstract boolean isAllowWrite(Connection var1) throws SQLException;

    protected abstract boolean isAllowDelete(Connection var1) throws SQLException;

    protected DruidDataSource configDataSourceByObProxy(DataSourceInfo conf) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        if (conf.getPassword() != null) {
            properties.setProperty("password", conf.getPassword());
        }
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oceanbase://%s/%s?useUnicode=true&characterEncoding=utf-8&sessionVariables=ob_query_timeout=%s", conf.getObProxy(), conf.getDatabaseName(), conf.getQueryTimeout() * 1000 * 1000);
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
        properties.setProperty("validationQuery", "select 1");
        DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        ArrayList<String> initSql = new ArrayList<String>();
        initSql.add("set @@ob_org_cluster_id = 2147473648");
        druidDataSource.setConnectionInitSqls(initSql);
        druidDataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
        druidDataSource.setQueryTimeout(conf.getQueryTimeout());
        druidDataSource.setSocketTimeout(conf.getQueryTimeout() * 1000);
        return druidDataSource;
    }

    protected DruidDataSource configSysDataSourceByObProxy(DataSourceInfo conf) {
        try {
            Properties properties = new Properties();
            properties.setProperty("username", conf.getSysFullUserName());
            if (conf.getEncryptSysPassword() != null) {
                properties.setProperty("password", conf.getEncryptSysPassword());
            }
            properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
            properties.setProperty("maxWait", "10000");
            properties.setProperty("getConnectionTimeout", "10000");
            properties.setProperty("minIdle", "0");
            String url = String.format("jdbc:oceanbase://%s/%s?useUnicode=true&characterEncoding=utf-8&sessionVariables=ob_query_timeout=%s", conf.getObProxy(), conf.getSysDatabaseName(), conf.getQueryTimeout() * 1000 * 1000);
            properties.setProperty("url", url);
            properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
            properties.setProperty("initialSize", "0");
            properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
            properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
            properties.setProperty("validationQuery", "select 1");
            DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
            ArrayList<String> initSql = new ArrayList<String>();
            initSql.add("set @@ob_org_cluster_id = 2147473648");
            druidDataSource.setConnectionInitSqls(initSql);
            druidDataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
            druidDataSource.setConnectionErrorRetryAttempts(5);
            druidDataSource.setQueryTimeout(conf.getQueryTimeout());
            druidDataSource.setSocketTimeout(conf.getQueryTimeout() * 1000);
            druidDataSource.init();
            this.updateRateLimiter(conf.getRateLimit());
            return druidDataSource;
        }
        catch (Exception e) {
            log.warn(String.format("fail to init oceanbaseV10 SYS dataSource, ds=%s, conf=%s", this.dataSourceInfo.getDataSourceName(), conf), (Throwable)e);
            return null;
        }
    }

    protected String getCurrentTenantName(Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("show tenant");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    protected Long getTenantId(String tenantName, Connection connection) throws SQLException {
        String currentTenant = this.getCurrentTenantName(connection);
        if (StringUtils.isEmpty((String)currentTenant)) {
            throw new UnExpectedException("Init tenant info failed.");
        }
        PreparedStatement ps = connection.prepareStatement(this.getQueryTenantIdSql(currentTenant));
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getLong("tenant_id");
        }
        throw new UnExpectedException("Init tenant info failed.");
    }

    protected String getClusterName(Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("show parameters like 'cluster'");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getString("value");
        }
        throw new UnExpectedException("Init cluster info failed.");
    }

    protected void waitAvailable(Connection connection) throws SQLException {
        while (System.currentTimeMillis() - this.lastWriteValidTime > 1000L * (long)MainFramework.getWritableCheckInterval()) {
            if (!this.isAllowWrite(connection)) {
                try {
                    log.info(String.format("write is not allowed, sleep for %d seconds", this.sleepTime));
                    Thread.sleep((long)this.sleepTime * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.lastWriteValidTime = System.currentTimeMillis();
        }
    }

    protected void waitDeleteAvailable(Connection connection) throws SQLException {
        while (System.currentTimeMillis() - this.lastDeleteValidTime > 1000L * (long)MainFramework.getDeletableCheckInterval()) {
            if (!this.isAllowDelete(connection)) {
                try {
                    int sleepSeconds = new Random().nextInt(10) + 10;
                    log.info(String.format("delete is not allowed, sleep for %d seconds", sleepSeconds));
                    Thread.sleep(sleepSeconds * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.lastDeleteValidTime = System.currentTimeMillis();
        }
    }

    protected String getTenantMemQuerySql() {
        if (this.isGreaterThanOB4X()) {
            return String.format("SELECT mem.SVR_IP, mem.MEMSTORE_USED, mem.FREEZE_TRIGGER FROM oceanbase.gv$ob_memstore AS mem where mem.tenant_id = '%s' AND (mem.MEMSTORE_USED >= mem.FREEZE_TRIGGER * 1.05);", this.dataSourceInfo.getTenantId());
        }
        return String.format("SELECT mem.IP, mem.TOTAL, mem.FREEZE_TRIGGER FROM oceanbase.gv$memstore AS mem where mem.tenant_id = '%s' AND (mem.TOTAL >= mem.FREEZE_TRIGGER * 1.05)", this.dataSourceInfo.getTenantId());
    }

    protected String getTenantCpuQuerySql() {
        return String.format("SELECT cpu_usage.svr_ip svr_ip, round(cpu_usage.value * 100 / cpu_limit.value) cpu_percent FROM oceanbase.gv$sysstat cpu_usage, oceanbase.gv$sysstat cpu_limit WHERE cpu_usage.CON_ID = '%s' AND cpu_limit.CON_ID = '%s' AND cpu_usage.name = 'cpu usage' AND cpu_limit.name = 'max cpus' AND cpu_usage.svr_ip = cpu_limit.svr_ip HAVING cpu_percent > 0", this.dataSourceInfo.getTenantId(), this.dataSourceInfo.getTenantId());
    }

    protected String getQueryTenantIdSql(String tenantName) {
        if (this.isGreaterThanOB4X()) {
            return String.format("SELECT tenant_id FROM oceanbase.DBA_OB_TENANTS WHERE tenant_name = '%s'", tenantName);
        }
        return String.format("SELECT tenant_id FROM oceanbase.gv$tenant WHERE tenant_name = '%s'", tenantName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableSizeInfo queryTableRowCount(Connection connection, String tableName, String dbName) throws SQLException {
        TableSizeInfo tableSizeInfo = new TableSizeInfo();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement("select TABLE_ROWS, DATA_LENGTH from `information_schema`.`tables` where table_schema= ?  and table_name= ?");
            ps.setString(1, this.getSchema());
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                tableSizeInfo.setTableRowCount(rs.getLong("TABLE_ROWS"));
                tableSizeInfo.setDataSize(rs.getLong("DATA_LENGTH"));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)ps);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
        return tableSizeInfo;
    }

    /*
     * Exception decompiling
     */
    public static String queryOBVersion(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String parseObVersionComment(String obVersionComment) {
        Validate.notBlank((CharSequence)obVersionComment);
        String[] obVersion = obVersionComment.split("\\s+");
        if (obVersion == null) {
            throw new NullPointerException("version_comment cannot be empty");
        }
        if (obVersion.length < 4) {
            throw new IllegalArgumentException("version_comment get failed");
        }
        return obVersion[1];
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        log.info("set sleep time = {}", (Object)sleepTime);
    }

    public boolean isGreaterThanOB4X() {
        return VersionUtil.compareVersions(this.obVersion, "4.0.0") > 0;
    }
}

