/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.MetaDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.MysqlDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObMySQLModeDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObOracleModeDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.OracleDataSourceAdapter;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataSourceFactory.class);

    public static DataSourceAdapter getMetaDatasource(DataSourceInfo dataSourceInfo) {
        return new MetaDataSourceAdapter(dataSourceInfo);
    }

    public static DataSourceAdapter getDataSource(DataSourceInfo conf) throws Exception {
        AbstractDataSourceAdapter dataSource = null;
        switch (conf.getDatabaseType()) {
            case OCEANBASEV10: {
                dataSource = new ObMySQLModeDataSourceAdapter(conf);
                break;
            }
            case MYSQL: {
                dataSource = new MysqlDataSourceAdapter(conf);
                break;
            }
            case ORACLE: {
                dataSource = new OracleDataSourceAdapter(conf);
                break;
            }
            case OCEANBASE_ORACLE_MODE: {
                dataSource = new ObOracleModeDataSourceAdapter(conf);
                break;
            }
            default: {
                log.warn(String.format("unsupported database type, type=%s", conf.getDatabaseType().toString()));
            }
        }
        try (Connection connectionTest = dataSource.getConnectionReadOnly();){
            if (!connectionTest.getAutoCommit()) {
                log.info("datasource " + (Object)((Object)conf.getDatabaseType()) + " auto commit: " + connectionTest.getAutoCommit());
                throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, "dataSource " + conf.getDataSourceName() + " auto commit is false");
            }
        }
        catch (Exception e) {
            throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, "dataSource init failed");
        }
        return dataSource;
    }
}

