/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ExceptionSorter;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.datasource.AbstractObDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObOracleExceptionSorter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleModeDataSourceAdapter
extends AbstractObDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObOracleModeDataSourceAdapter.class);
    private DruidDataSource druidDataSource;
    private static final String ALL_TABLES = "ALL_TABLES";
    private static final String IS_PARTITION_TABLE_SQL = String.format("SELECT PARTITIONED FROM %s WHERE OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TABLES");
    private static final String ALL_TAB_PARTITIONS = "ALL_TAB_PARTITIONS";
    private static final String GET_PARTITION_NAME_SQL = String.format("SELECT PARTITION_NAME FROM %s WHERE TABLE_OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TAB_PARTITIONS");
    private static final String CHECK_MEMSTORE = "SELECT 1 from SYS.GV$MEMSTORE WHERE (TOTAL >= FREEZE_TRIGGER * 1.05)";
    private static final String QUERY_CPU_PERCENT_INFO = "SELECT cpu_usage.svr_ip svr_ip, round(cpu_usage.value * 100 / cpu_limit.value) cpu_percent FROM SYS.gv$sysstat cpu_usage, SYS.gv$sysstat cpu_limit WHERE cpu_usage.name = 'cpu usage' AND cpu_limit.name = 'max cpus' AND cpu_usage.svr_ip = cpu_limit.svr_ip";
    private static final int CPU_PERCENT_THRESHOLD = 25;

    public ObOracleModeDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        properties.setProperty("password", conf.getPassword());
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oceanbase://%s:%d/%s?useUnicode=true&characterEncoding=utf-8", conf.getIp(), conf.getPort(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
        properties.setProperty("validationQuery", "select 1 from dual");
        this.druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        ArrayList<String> initSqls = new ArrayList<String>(4);
        initSqls.add("ALTER SESSION SET NLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS';");
        initSqls.add("ALTER SESSION SET NLS_TIMESTAMP_FORMAT='YYYY-MM-DD HH24:MI:SS.FF';");
        initSqls.add("ALTER SESSION SET NLS_TIMESTAMP_TZ_FORMAT='YYYY-MM-DD HH24:MI:SS.FF TZR TZD';");
        initSqls.add("set @@ob_org_cluster_id = 2147473648");
        this.druidDataSource.setConnectionInitSqls(initSqls);
        this.druidDataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowWrite(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowDelete(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getDbVersion() throws SQLException {
        return null;
    }

    @Override
    public Boolean isPartitionTable(String tableName) throws SQLException {
        try (DruidPooledConnection connection = this.druidDataSource.getConnection();){
            QueryRunner queryRunner = new QueryRunner();
            Object[] params = new String[]{this.dataSourceInfo.getDatabaseName().toUpperCase(), tableName.toUpperCase()};
            List result = (List)queryRunner.query((Connection)connection, IS_PARTITION_TABLE_SQL, (ResultSetHandler)new MapListHandler(), params);
            if (result.isEmpty()) {
                Boolean bl = false;
                return bl;
            }
            Boolean bl = "YES".equals(((Map)result.get(0)).get("PARTITIONED"));
            return bl;
        }
    }

    @Override
    public List<String> getPartitionNames(String tableName) throws SQLException {
        try (DruidPooledConnection connection = this.druidDataSource.getConnection();){
            QueryRunner queryRunner = new QueryRunner();
            Object[] params = new String[]{this.dataSourceInfo.getDatabaseName().toUpperCase(), tableName.toUpperCase()};
            List result = (List)queryRunner.query((Connection)connection, GET_PARTITION_NAME_SQL, (ResultSetHandler)new MapListHandler(), params);
            List<String> list = result.stream().map(o -> (String)o.get("PARTITION_NAME")).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public TableSizeInfo getSourceTableSizeInfo(String tableName) throws SQLException {
        try (Connection conn = this.getConnection();){
            TableSizeInfo tableSizeInfo = this.queryTableRowCount(conn, tableName, this.dataSourceInfo.getDatabaseName());
            return tableSizeInfo;
        }
    }

    @Override
    public void closeDataSource() {
        super.closeDataSource();
        if (this.druidDataSource != null) {
            this.druidDataSource.close();
        }
    }
}

