/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class OracleDataSourceAdapter
extends AbstractDataSourceAdapter {
    private DruidDataSource druidDataSource;
    private static final String ALL_TABLES = "ALL_TABLES";
    private static final String IS_PARTITION_TABLE_SQL = String.format("SELECT PARTITIONED FROM %s WHERE OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TABLES");
    private static final String ALL_TAB_PARTITIONS = "ALL_TAB_PARTITIONS";
    private static final String GET_PARTITION_NAME_SQL = String.format("SELECT PARTITION_NAME FROM %s WHERE TABLE_OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TAB_PARTITIONS");

    public OracleDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        properties.setProperty("password", conf.getPassword());
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oracle:thin:@%s:%d:%s", conf.getIp(), conf.getPort(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("driverClassName", "oracle.jdbc.OracleDriver");
        this.druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.getConnection();
    }

    @Override
    public String getDbVersion() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isPartitionTable(String tableName) throws SQLException {
        boolean isPar = false;
        DruidPooledConnection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.druidDataSource.getConnection();
            ps = connection.prepareStatement(IS_PARTITION_TABLE_SQL);
            ps.setString(1, this.dataSourceInfo.getDatabaseName().toUpperCase());
            ps.setString(2, tableName.toUpperCase());
            rs = ps.executeQuery();
            String isPartition = "";
            while (rs.next()) {
                isPartition = rs.getString(1);
            }
            isPar = isPartition.equalsIgnoreCase("YES");
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly(rs);
        DbUtils.closeQuietly(ps);
        DbUtils.closeQuietly((Connection)connection);
        return isPar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPartitionNames(String tableName) throws SQLException {
        ArrayList<String> partitionName = new ArrayList<String>();
        DruidPooledConnection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.druidDataSource.getConnection();
            ps = connection.prepareStatement(GET_PARTITION_NAME_SQL);
            ps.setString(1, this.dataSourceInfo.getDatabaseName().toUpperCase());
            ps.setString(2, tableName.toUpperCase());
            rs = ps.executeQuery();
            while (rs.next()) {
                partitionName.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly(rs);
        DbUtils.closeQuietly(ps);
        DbUtils.closeQuietly((Connection)connection);
        return partitionName;
    }

    @Override
    public void closeDataSource() {
        super.closeDataSource();
        if (this.druidDataSource != null) {
            this.druidDataSource.close();
        }
    }
}

