/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource.calculator;

import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.tools.migrator.datasource.calculator.IPartIdCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBPartIdCalculator
extends ObPartIdCalculator
implements IPartIdCalculator {
    private static final Logger log = LoggerFactory.getLogger(OBPartIdCalculator.class);

    public OBPartIdCalculator(TableEntry tableEntry) {
        super(tableEntry);
    }

    public OBPartIdCalculator(boolean publicCloud, TableEntry tableEntry) {
        super(publicCloud, tableEntry);
    }

    public OBPartIdCalculator(boolean publicCloud, TableEntry tableEntry, boolean subsequentFromV4) {
        super(publicCloud, tableEntry, subsequentFromV4);
    }

    @Override
    public boolean isPartitionKeyColumn(String name) {
        if (super.getTableEntry().isNonPartitionTable()) {
            return false;
        }
        String realName = OBPartIdCalculator.getRealColumnName(name);
        for (ObPartColumn column : super.getTableEntry().getTablePart().getPartColumns()) {
            if (!column.getColumnName().equalsIgnoreCase(realName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addColumn(String name, Object value) {
        super.addRefColumn(name, value);
    }

    @Override
    public Long calculate() {
        if (super.getTableEntry().isNonPartitionTable()) {
            log.debug(String.format("not a partition table, tableName = %s", this.getTableEntry().getTableName()));
            return 0L;
        }
        Long partId = null;
        try {
            partId = super.calculatePartId(new Object[]{null});
        }
        catch (Exception e) {
            log.warn(String.format("failed to calculate partition id, entry=%s, expr=%s", super.getTableEntry(), super.getExprCacheMap()));
        }
        return partId;
    }

    @Override
    public Long calculate(Object[] records) {
        return super.calculatePartId(records);
    }

    @Override
    public void clearColumns() {
        super.getExprCacheMap().clear();
    }

    private static String getRealColumnName(String name) {
        String realColumnName = name;
        if (name != null && name.length() > 2 && name.startsWith("`") && name.endsWith("`")) {
            realColumnName = name.substring(1, name.length() - 1);
        }
        return realColumnName;
    }
}

