/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.framework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;

public class NativeFSLock {
    private File path;
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;

    public NativeFSLock(File lockDir) {
        this.path = new File(lockDir, "worker.pid");
    }

    private synchronized boolean lockExists() {
        return this.lock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean obtain() throws IOException {
        if (this.lockExists()) {
            return false;
        }
        try {
            this.f = new RandomAccessFile(this.path, "rw");
        }
        catch (IOException e) {
            this.f = null;
        }
        if (this.f != null) {
            try {
                this.channel = this.f.getChannel();
                try {
                    this.lock = this.channel.tryLock();
                    ByteBuffer buffer = Charset.forName("utf8").encode(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
                    this.channel.truncate(0L);
                    while (this.channel.write(buffer) > 0) {
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (this.lock == null) {
                        try {
                            this.channel.close();
                        }
                        finally {
                            this.channel = null;
                        }
                    }
                }
            }
            finally {
                if (this.channel == null) {
                    try {
                        this.f.close();
                    }
                    finally {
                        this.f = null;
                    }
                }
            }
        }
        return this.lockExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws IOException {
        if (this.lockExists()) {
            try {
                this.lock.release();
            }
            finally {
                this.lock = null;
                try {
                    this.channel.close();
                }
                finally {
                    this.channel = null;
                    try {
                        this.f.close();
                    }
                    finally {
                        this.f = null;
                    }
                }
            }
            this.path.delete();
        }
    }

    public String toString() {
        return this.path + "";
    }

    public static void lock(NativeFSLock lock) {
        try {
            boolean locked = false;
            if (lock != null) {
                locked = lock.obtain();
            }
            if (!locked) {
                throw new RuntimeException("Lock failed");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void unlock(NativeFSLock lock) {
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unlock failed");
        }
    }
}

