/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.framework;

import com.oceanbase.tools.migrator.common.util.JarToolUtil;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private static VersionInfo versionInfo = null;
    private String branch;
    private String commitId;
    private String commitIdAbbrev;
    private String commitUserName;
    private String commitUserEmail;
    private String commitMessageShort;
    private String commitTime;
    private String buildUserName;
    private String buildTime;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo versionInfo() {
        if (versionInfo == null) {
            InputStream input = null;
            Properties properties = new Properties();
            Manifest manifest = null;
            try {
                log.info(String.format("current class.getClassLoader().getResource path, %s", VersionInfo.class.getClassLoader().getResource("")));
                input = VersionInfo.class.getClassLoader().getResourceAsStream("git.migration_client_properties");
                String jarPath = JarToolUtil.getJarDir() + "/obhistory-worker.jar";
                log.info(String.format("current obhistory-worker.jar path, %s", jarPath));
                JarFile jar = new JarFile(jarPath);
                manifest = jar.getManifest();
                if (null == input) {
                    log.warn(String.format("fail to get git.migration_client_properties in path, %s ", VersionInfo.class.getClassLoader().getResource("")));
                } else if (null == manifest) {
                    log.warn(String.format("fail to get Manifest in path, %s", jarPath));
                } else {
                    properties.load(input);
                }
                versionInfo = new VersionInfo(properties, manifest);
            }
            catch (Exception ie) {
                try {
                    log.error(String.format("fail to get version file, errMsg=%s", ie.getMessage()), (Throwable)ie);
                    versionInfo = new VersionInfo(properties, manifest);
                }
                catch (Throwable throwable) {
                    versionInfo = new VersionInfo(properties, manifest);
                    log.info(String.format("versionInfo =  %s", versionInfo.toString()));
                    if (null != input) {
                        try {
                            input.close();
                        }
                        catch (Exception e) {
                            log.error(String.format("fail to close InputStream, errMsg=%s", e.getMessage()), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                log.info(String.format("versionInfo =  %s", versionInfo.toString()));
                if (null != input) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        log.error(String.format("fail to close InputStream, errMsg=%s", e.getMessage()), (Throwable)e);
                    }
                }
            }
            log.info(String.format("versionInfo =  %s", versionInfo.toString()));
            if (null != input) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    log.error(String.format("fail to close InputStream, errMsg=%s", e.getMessage()), (Throwable)e);
                }
            }
        }
        return versionInfo;
    }

    private String getProperty(Properties properties, String key) {
        Object value = properties.get(key);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    private VersionInfo(Properties properties, Manifest manifest) {
        if (null != properties) {
            this.branch = this.getProperty(properties, "git.branch");
            this.commitId = this.getProperty(properties, "git.commit.id");
            this.commitIdAbbrev = this.getProperty(properties, "git.commit.id.abbrev");
            this.commitUserName = this.getProperty(properties, "git.commit.user.name");
            this.commitUserEmail = this.getProperty(properties, "git.commit.user.email");
            this.commitMessageShort = this.getProperty(properties, "git.commit.message.short");
            this.commitTime = this.getProperty(properties, "git.commit.time");
            this.buildUserName = this.getProperty(properties, "git.build.user.name");
            this.buildTime = this.getProperty(properties, "git.build.time");
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                this.version = attributes.getValue("Project-Version");
            } else {
                this.version = null;
            }
        }
    }

    public String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("VersionInfo [").append("  branch=").append(this.branch).append(", commitId=").append(this.commitId).append(", commitIdAbbrev=").append(this.commitIdAbbrev).append(", commitUserName=").append(this.commitUserName).append(", commitUserEmail=").append(this.commitUserEmail).append(", commitMessageShort=").append(this.commitMessageShort).append(", commitTime=").append(this.commitTime).append(", buildUserName=").append(this.buildUserName).append(", buildTime=").append(this.buildTime).append("  version=").append(this.version).append("]");
        return buffer.toString();
    }
}

