/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.configure;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;

public class SizeAndDateFileAppender
extends RollingFileAppender {
    private String datePattern;
    private String dateStr = "";
    private String expirDays = "14";
    private String isCleanLog = "true";
    private String maxIndex = "100";
    private File rootDir;

    public void setDatePattern(String datePattern) {
        if (null != datePattern && !"".equals(datePattern)) {
            this.datePattern = datePattern;
        }
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void rollOver() {
        this.dateStr = new SimpleDateFormat(this.datePattern).format(new Date(System.currentTimeMillis()));
        File newFile = null;
        File file = null;
        int count = this.getAndDropLog();
        newFile = new File(this.fileName + this.dateStr + "." + (count + 1));
        this.closeFile();
        file = new File(this.fileName);
        LogLog.debug((String)("Renaming file" + file + "to" + newFile));
        file.renameTo(newFile);
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ",false)call failed."), (Throwable)e);
        }
    }

    public int getAndDropLog() {
        int count = 0;
        if (Boolean.parseBoolean(this.isCleanLog)) {
            File[] listFiles;
            File f = new File(this.fileName);
            this.rootDir = f.getParentFile();
            for (File file : listFiles = this.rootDir.listFiles()) {
                if (file.getName().contains(this.dateStr)) {
                    ++count;
                }
                if (!this.isExpTime(file.lastModified()).booleanValue()) continue;
                file.delete();
            }
        }
        return count;
    }

    public Boolean isExpTime(long timestamp) {
        SimpleDateFormat format = new SimpleDateFormat(this.datePattern);
        try {
            Date logDate = new Date(timestamp);
            Date nowDate = format.parse(format.format(new Date()));
            int days = (int)(nowDate.getTime() - logDate.getTime()) / 86400000;
            return Math.abs(days) >= Integer.parseInt(this.expirDays);
        }
        catch (Exception e) {
            LogLog.error((String)e.toString());
            return false;
        }
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public String getExpirDays() {
        return this.expirDays;
    }

    public void setExpirDays(String expirDays) {
        this.expirDays = expirDays;
    }

    public String getIsCleanLog() {
        return this.isCleanLog;
    }

    public void setIsCleanLog(String isCleanLog) {
        this.isCleanLog = isCleanLog;
    }

    public String getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(String maxIndex) {
        this.maxIndex = maxIndex;
    }
}

