/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.dto;

import com.oceanbase.tools.migrator.core.stat.JobStat;
import java.util.Map;

public class JobStatistic {
    private String jobId;
    private Long dataSize = 0L;
    private Long dataSizePs = 0L;
    private Long rowCount = 0L;
    private Long rowCountPs = 0L;
    private Long avgPutWaitTimeUs = 0L;
    private Long avgTakeWaitTimeUs = 0L;
    private Long unmatchedRowCount = 0L;
    private Long readRowCount = 0L;
    private Long readRowCountPs = 0L;
    private Long totalRowCount = 0L;
    private String cpuLimit;
    private String memLimit;

    public JobStatistic(Map<String, Object> jobEntry) {
        this.jobId = (String)jobEntry.get("job_id");
        this.dataSize = (Long)jobEntry.get("data_size");
        this.dataSizePs = (Long)jobEntry.get("data_size_ps");
        this.rowCount = (Long)jobEntry.get("row_count");
        this.rowCountPs = (Long)jobEntry.get("row_count_ps");
        this.avgPutWaitTimeUs = (Long)jobEntry.get("avg_put_wait_time_us");
        this.avgTakeWaitTimeUs = (Long)jobEntry.get("avg_take_wait_time_us");
        this.unmatchedRowCount = (Long)jobEntry.get("unmatched_row_count");
        this.readRowCount = (Long)jobEntry.get("read_row_count");
        this.readRowCountPs = (Long)jobEntry.get("read_row_count_ps");
        this.totalRowCount = (Long)jobEntry.get("total_row_count");
    }

    public JobStatistic(String jobId, JobStat jobStat) {
        this.jobId = jobId;
        this.dataSize = jobStat.getDataSize();
        this.dataSizePs = jobStat.getAvgDataSize();
        this.rowCount = jobStat.getRowCount();
        this.rowCountPs = jobStat.getAvgRowCount();
        this.avgPutWaitTimeUs = jobStat.getPutWaitTimeUs() / (jobStat.getPutTimes() > 0L ? jobStat.getPutTimes() : 1L);
        this.avgTakeWaitTimeUs = jobStat.getTakeWaitTimeUs() / (jobStat.getTakeTimes() > 0L ? jobStat.getTakeTimes() : 1L);
        this.unmatchedRowCount = jobStat.getUnMatchedRowCount();
        this.readRowCount = jobStat.getReadRowCount();
        this.readRowCountPs = jobStat.getAvgReadRowCount();
        this.totalRowCount = jobStat.getTotalRowCount();
    }

    public String getJobId() {
        return this.jobId;
    }

    public Long getDataSize() {
        return this.dataSize;
    }

    public Long getDataSizePs() {
        return this.dataSizePs;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public Long getRowCountPs() {
        return this.rowCountPs;
    }

    public Long getAvgPutWaitTimeUs() {
        return this.avgPutWaitTimeUs;
    }

    public Long getAvgTakeWaitTimeUs() {
        return this.avgTakeWaitTimeUs;
    }

    public Long getUnmatchedRowCount() {
        return this.unmatchedRowCount;
    }

    public Long getReadRowCount() {
        return this.readRowCount;
    }

    public Long getReadRowCountPs() {
        return this.readRowCountPs;
    }

    public Long getTotalRowCount() {
        return this.totalRowCount;
    }

    public String getCpuLimit() {
        return this.cpuLimit;
    }

    public String getMemLimit() {
        return this.memLimit;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setDataSize(Long dataSize) {
        this.dataSize = dataSize;
    }

    public void setDataSizePs(Long dataSizePs) {
        this.dataSizePs = dataSizePs;
    }

    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    public void setRowCountPs(Long rowCountPs) {
        this.rowCountPs = rowCountPs;
    }

    public void setAvgPutWaitTimeUs(Long avgPutWaitTimeUs) {
        this.avgPutWaitTimeUs = avgPutWaitTimeUs;
    }

    public void setAvgTakeWaitTimeUs(Long avgTakeWaitTimeUs) {
        this.avgTakeWaitTimeUs = avgTakeWaitTimeUs;
    }

    public void setUnmatchedRowCount(Long unmatchedRowCount) {
        this.unmatchedRowCount = unmatchedRowCount;
    }

    public void setReadRowCount(Long readRowCount) {
        this.readRowCount = readRowCount;
    }

    public void setReadRowCountPs(Long readRowCountPs) {
        this.readRowCountPs = readRowCountPs;
    }

    public void setTotalRowCount(Long totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    public void setCpuLimit(String cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public void setMemLimit(String memLimit) {
        this.memLimit = memLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobStatistic)) {
            return false;
        }
        JobStatistic other = (JobStatistic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        Long this$dataSize = this.getDataSize();
        Long other$dataSize = other.getDataSize();
        if (this$dataSize == null ? other$dataSize != null : !((Object)this$dataSize).equals(other$dataSize)) {
            return false;
        }
        Long this$dataSizePs = this.getDataSizePs();
        Long other$dataSizePs = other.getDataSizePs();
        if (this$dataSizePs == null ? other$dataSizePs != null : !((Object)this$dataSizePs).equals(other$dataSizePs)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$rowCountPs = this.getRowCountPs();
        Long other$rowCountPs = other.getRowCountPs();
        if (this$rowCountPs == null ? other$rowCountPs != null : !((Object)this$rowCountPs).equals(other$rowCountPs)) {
            return false;
        }
        Long this$avgPutWaitTimeUs = this.getAvgPutWaitTimeUs();
        Long other$avgPutWaitTimeUs = other.getAvgPutWaitTimeUs();
        if (this$avgPutWaitTimeUs == null ? other$avgPutWaitTimeUs != null : !((Object)this$avgPutWaitTimeUs).equals(other$avgPutWaitTimeUs)) {
            return false;
        }
        Long this$avgTakeWaitTimeUs = this.getAvgTakeWaitTimeUs();
        Long other$avgTakeWaitTimeUs = other.getAvgTakeWaitTimeUs();
        if (this$avgTakeWaitTimeUs == null ? other$avgTakeWaitTimeUs != null : !((Object)this$avgTakeWaitTimeUs).equals(other$avgTakeWaitTimeUs)) {
            return false;
        }
        Long this$unmatchedRowCount = this.getUnmatchedRowCount();
        Long other$unmatchedRowCount = other.getUnmatchedRowCount();
        if (this$unmatchedRowCount == null ? other$unmatchedRowCount != null : !((Object)this$unmatchedRowCount).equals(other$unmatchedRowCount)) {
            return false;
        }
        Long this$readRowCount = this.getReadRowCount();
        Long other$readRowCount = other.getReadRowCount();
        if (this$readRowCount == null ? other$readRowCount != null : !((Object)this$readRowCount).equals(other$readRowCount)) {
            return false;
        }
        Long this$readRowCountPs = this.getReadRowCountPs();
        Long other$readRowCountPs = other.getReadRowCountPs();
        if (this$readRowCountPs == null ? other$readRowCountPs != null : !((Object)this$readRowCountPs).equals(other$readRowCountPs)) {
            return false;
        }
        Long this$totalRowCount = this.getTotalRowCount();
        Long other$totalRowCount = other.getTotalRowCount();
        if (this$totalRowCount == null ? other$totalRowCount != null : !((Object)this$totalRowCount).equals(other$totalRowCount)) {
            return false;
        }
        String this$cpuLimit = this.getCpuLimit();
        String other$cpuLimit = other.getCpuLimit();
        if (this$cpuLimit == null ? other$cpuLimit != null : !this$cpuLimit.equals(other$cpuLimit)) {
            return false;
        }
        String this$memLimit = this.getMemLimit();
        String other$memLimit = other.getMemLimit();
        return !(this$memLimit == null ? other$memLimit != null : !this$memLimit.equals(other$memLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobStatistic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        Long $dataSize = this.getDataSize();
        result = result * 59 + ($dataSize == null ? 43 : ((Object)$dataSize).hashCode());
        Long $dataSizePs = this.getDataSizePs();
        result = result * 59 + ($dataSizePs == null ? 43 : ((Object)$dataSizePs).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $rowCountPs = this.getRowCountPs();
        result = result * 59 + ($rowCountPs == null ? 43 : ((Object)$rowCountPs).hashCode());
        Long $avgPutWaitTimeUs = this.getAvgPutWaitTimeUs();
        result = result * 59 + ($avgPutWaitTimeUs == null ? 43 : ((Object)$avgPutWaitTimeUs).hashCode());
        Long $avgTakeWaitTimeUs = this.getAvgTakeWaitTimeUs();
        result = result * 59 + ($avgTakeWaitTimeUs == null ? 43 : ((Object)$avgTakeWaitTimeUs).hashCode());
        Long $unmatchedRowCount = this.getUnmatchedRowCount();
        result = result * 59 + ($unmatchedRowCount == null ? 43 : ((Object)$unmatchedRowCount).hashCode());
        Long $readRowCount = this.getReadRowCount();
        result = result * 59 + ($readRowCount == null ? 43 : ((Object)$readRowCount).hashCode());
        Long $readRowCountPs = this.getReadRowCountPs();
        result = result * 59 + ($readRowCountPs == null ? 43 : ((Object)$readRowCountPs).hashCode());
        Long $totalRowCount = this.getTotalRowCount();
        result = result * 59 + ($totalRowCount == null ? 43 : ((Object)$totalRowCount).hashCode());
        String $cpuLimit = this.getCpuLimit();
        result = result * 59 + ($cpuLimit == null ? 43 : $cpuLimit.hashCode());
        String $memLimit = this.getMemLimit();
        result = result * 59 + ($memLimit == null ? 43 : $memLimit.hashCode());
        return result;
    }

    public String toString() {
        return "JobStatistic(jobId=" + this.getJobId() + ", dataSize=" + this.getDataSize() + ", dataSizePs=" + this.getDataSizePs() + ", rowCount=" + this.getRowCount() + ", rowCountPs=" + this.getRowCountPs() + ", avgPutWaitTimeUs=" + this.getAvgPutWaitTimeUs() + ", avgTakeWaitTimeUs=" + this.getAvgTakeWaitTimeUs() + ", unmatchedRowCount=" + this.getUnmatchedRowCount() + ", readRowCount=" + this.getReadRowCount() + ", readRowCountPs=" + this.getReadRowCountPs() + ", totalRowCount=" + this.getTotalRowCount() + ", cpuLimit=" + this.getCpuLimit() + ", memLimit=" + this.getMemLimit() + ")";
    }

    public JobStatistic() {
    }
}

