/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.meta;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TableMeta {
    private String schema;
    private String name;
    private long tableId;
    private List<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
    private Map<String, ColumnMeta> columnMetaMap = new HashMap<String, ColumnMeta>(50);
    private List<ColumnMeta> primaryColumnMetas = new ArrayList<ColumnMeta>(3);
    private List<ColumnMeta> sortedPrimaryColumnMetas = new ArrayList<ColumnMeta>(3);
    private DataBaseType dataBaseType = DataBaseType.UNKNOWN;
    private String pkColumnListStr = null;
    private String columnListStr = null;
    private int readRowCountLimit = 0;
    private int writeRowCountLimit = 0;

    public void addColumnMeta(ColumnMeta columnMeta) {
        columnMeta.setColIdx(this.columnMetas.size());
        this.columnMetas.add(columnMeta);
        this.columnMetaMap.put(columnMeta.getName(), columnMeta);
        if (columnMeta.getPkColIdx() != -1) {
            this.primaryColumnMetas.add(columnMeta);
        }
    }

    public ColumnMeta getColumnMeta(String columnName) {
        return this.columnMetaMap.get(columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPkColumnListStr() {
        if (this.pkColumnListStr == null) {
            TableMeta tableMeta = this;
            synchronized (tableMeta) {
                if (this.pkColumnListStr == null) {
                    this.pkColumnListStr = this.dataBaseType == DataBaseType.ORACLE || this.dataBaseType == DataBaseType.OCEANBASE_ORACLE_MODE ? SqlUtils.getOracleColumnListStr(this.getSortedPrimaryColumnMetas()) : SqlUtils.getColumnListStr(this.getSortedPrimaryColumnMetas());
                }
            }
        }
        return this.pkColumnListStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnListStr() {
        if (this.columnListStr == null) {
            TableMeta tableMeta = this;
            synchronized (tableMeta) {
                if (this.columnListStr == null) {
                    this.columnListStr = this.dataBaseType == DataBaseType.ORACLE || this.dataBaseType == DataBaseType.OCEANBASE_ORACLE_MODE ? SqlUtils.getOracleColumnListStr(this.getColumnMetas()) : SqlUtils.getColumnListStr(this.getColumnMetas());
                }
            }
        }
        return this.columnListStr;
    }

    public int getPrimaryKeyCount() {
        return this.primaryColumnMetas.size();
    }

    public boolean hasSamePk(TableMeta targetTableMeta) {
        boolean ret = false;
        List<ColumnMeta> targetSortedPkColumns = targetTableMeta.getSortedPrimaryColumnMetas();
        if (this.sortedPrimaryColumnMetas.size() == targetSortedPkColumns.size()) {
            int i;
            for (i = 0; i < this.sortedPrimaryColumnMetas.size() && this.sortedPrimaryColumnMetas.get(i).getName().equalsIgnoreCase(targetSortedPkColumns.get(i).getName()); ++i) {
            }
            if (i == this.sortedPrimaryColumnMetas.size()) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean isPkColumn(String columnName) {
        return this.getPkColIdx(columnName) != -1;
    }

    public int getPkColIdx(String columnName) {
        int ret = -1;
        if (null != columnName) {
            for (ColumnMeta columnMeta : this.sortedPrimaryColumnMetas) {
                if (!columnMeta.getName().equalsIgnoreCase(columnName)) continue;
                ret = columnMeta.getPkColIdx();
            }
        }
        return ret;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("column metas", this.columnMetas).append("primary column metas", this.primaryColumnMetas).toString();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public long getTableId() {
        return this.tableId;
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    public Map<String, ColumnMeta> getColumnMetaMap() {
        return this.columnMetaMap;
    }

    public List<ColumnMeta> getPrimaryColumnMetas() {
        return this.primaryColumnMetas;
    }

    public List<ColumnMeta> getSortedPrimaryColumnMetas() {
        return this.sortedPrimaryColumnMetas;
    }

    public DataBaseType getDataBaseType() {
        return this.dataBaseType;
    }

    public int getReadRowCountLimit() {
        return this.readRowCountLimit;
    }

    public int getWriteRowCountLimit() {
        return this.writeRowCountLimit;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public void setColumnMetas(List<ColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
    }

    public void setColumnMetaMap(Map<String, ColumnMeta> columnMetaMap) {
        this.columnMetaMap = columnMetaMap;
    }

    public void setPrimaryColumnMetas(List<ColumnMeta> primaryColumnMetas) {
        this.primaryColumnMetas = primaryColumnMetas;
    }

    public void setSortedPrimaryColumnMetas(List<ColumnMeta> sortedPrimaryColumnMetas) {
        this.sortedPrimaryColumnMetas = sortedPrimaryColumnMetas;
    }

    public void setDataBaseType(DataBaseType dataBaseType) {
        this.dataBaseType = dataBaseType;
    }

    public void setPkColumnListStr(String pkColumnListStr) {
        this.pkColumnListStr = pkColumnListStr;
    }

    public void setColumnListStr(String columnListStr) {
        this.columnListStr = columnListStr;
    }

    public void setReadRowCountLimit(int readRowCountLimit) {
        this.readRowCountLimit = readRowCountLimit;
    }

    public void setWriteRowCountLimit(int writeRowCountLimit) {
        this.writeRowCountLimit = writeRowCountLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta other = (TableMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getTableId() != other.getTableId()) {
            return false;
        }
        List<ColumnMeta> this$columnMetas = this.getColumnMetas();
        List<ColumnMeta> other$columnMetas = other.getColumnMetas();
        if (this$columnMetas == null ? other$columnMetas != null : !((Object)this$columnMetas).equals(other$columnMetas)) {
            return false;
        }
        Map<String, ColumnMeta> this$columnMetaMap = this.getColumnMetaMap();
        Map<String, ColumnMeta> other$columnMetaMap = other.getColumnMetaMap();
        if (this$columnMetaMap == null ? other$columnMetaMap != null : !((Object)this$columnMetaMap).equals(other$columnMetaMap)) {
            return false;
        }
        List<ColumnMeta> this$primaryColumnMetas = this.getPrimaryColumnMetas();
        List<ColumnMeta> other$primaryColumnMetas = other.getPrimaryColumnMetas();
        if (this$primaryColumnMetas == null ? other$primaryColumnMetas != null : !((Object)this$primaryColumnMetas).equals(other$primaryColumnMetas)) {
            return false;
        }
        List<ColumnMeta> this$sortedPrimaryColumnMetas = this.getSortedPrimaryColumnMetas();
        List<ColumnMeta> other$sortedPrimaryColumnMetas = other.getSortedPrimaryColumnMetas();
        if (this$sortedPrimaryColumnMetas == null ? other$sortedPrimaryColumnMetas != null : !((Object)this$sortedPrimaryColumnMetas).equals(other$sortedPrimaryColumnMetas)) {
            return false;
        }
        DataBaseType this$dataBaseType = this.getDataBaseType();
        DataBaseType other$dataBaseType = other.getDataBaseType();
        if (this$dataBaseType == null ? other$dataBaseType != null : !((Object)((Object)this$dataBaseType)).equals((Object)other$dataBaseType)) {
            return false;
        }
        String this$pkColumnListStr = this.getPkColumnListStr();
        String other$pkColumnListStr = other.getPkColumnListStr();
        if (this$pkColumnListStr == null ? other$pkColumnListStr != null : !this$pkColumnListStr.equals(other$pkColumnListStr)) {
            return false;
        }
        String this$columnListStr = this.getColumnListStr();
        String other$columnListStr = other.getColumnListStr();
        if (this$columnListStr == null ? other$columnListStr != null : !this$columnListStr.equals(other$columnListStr)) {
            return false;
        }
        if (this.getReadRowCountLimit() != other.getReadRowCountLimit()) {
            return false;
        }
        return this.getWriteRowCountLimit() == other.getWriteRowCountLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $tableId = this.getTableId();
        result = result * 59 + (int)($tableId >>> 32 ^ $tableId);
        List<ColumnMeta> $columnMetas = this.getColumnMetas();
        result = result * 59 + ($columnMetas == null ? 43 : ((Object)$columnMetas).hashCode());
        Map<String, ColumnMeta> $columnMetaMap = this.getColumnMetaMap();
        result = result * 59 + ($columnMetaMap == null ? 43 : ((Object)$columnMetaMap).hashCode());
        List<ColumnMeta> $primaryColumnMetas = this.getPrimaryColumnMetas();
        result = result * 59 + ($primaryColumnMetas == null ? 43 : ((Object)$primaryColumnMetas).hashCode());
        List<ColumnMeta> $sortedPrimaryColumnMetas = this.getSortedPrimaryColumnMetas();
        result = result * 59 + ($sortedPrimaryColumnMetas == null ? 43 : ((Object)$sortedPrimaryColumnMetas).hashCode());
        DataBaseType $dataBaseType = this.getDataBaseType();
        result = result * 59 + ($dataBaseType == null ? 43 : ((Object)((Object)$dataBaseType)).hashCode());
        String $pkColumnListStr = this.getPkColumnListStr();
        result = result * 59 + ($pkColumnListStr == null ? 43 : $pkColumnListStr.hashCode());
        String $columnListStr = this.getColumnListStr();
        result = result * 59 + ($columnListStr == null ? 43 : $columnListStr.hashCode());
        result = result * 59 + this.getReadRowCountLimit();
        result = result * 59 + this.getWriteRowCountLimit();
        return result;
    }
}

