/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.meta;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaManager {
    private static final Logger log = LoggerFactory.getLogger(TableMetaManager.class);
    private static final String fieldColumn = "Field";
    private static final String obOracleExtraColumn = "EXTRA";
    private static Pattern VIRRUAL_GENERATED = Pattern.compile("VIRTUAL GENERATED");

    public static TableMeta getTableMeta(DataSourceAdapter ds, String tableName, long tableId) throws SQLException {
        TableMeta tableMeta;
        block6: {
            Connection connection = null;
            try {
                DataBaseType dataBaseType = ds.getDataBaseType();
                String tableOwner = ds.getSchema();
                connection = ds.getConnectionReadOnly();
                log.debug(String.format("get connection, connection = %s", connection));
                TableMeta tableMeta2 = new TableMeta();
                tableMeta2.setName(tableName);
                tableMeta2.setTableId(tableId);
                tableMeta2.setDataBaseType(dataBaseType);
                tableMeta2.setSchema(tableOwner);
                AbstractSqlBuilder abstractSqlBuilder = SqlBuilderFactory.getSqlBuilder(dataBaseType);
                List<ColumnMeta> columnMetas = TableMetaManager.selectTableMeta(abstractSqlBuilder, connection, tableName, dataBaseType, tableOwner);
                abstractSqlBuilder.resolvePkColumn(connection, tableName, columnMetas, tableOwner);
                for (ColumnMeta columnMeta : columnMetas) {
                    tableMeta2.addColumnMeta(columnMeta);
                }
                TableMetaManager.generateSortedPrimaryColumnMetas(tableMeta2);
                log.debug(String.format("dataSourceName: %s, tableName: %s, tableMata: %s", ds.getDataSourceInfo().getDataSourceName(), tableName, tableMeta2));
                tableMeta = tableMeta2;
                if (connection == null) break block6;
            }
            catch (SQLException e) {
                try {
                    log.warn("generate column meta failed", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        log.debug(String.format("close connection, connection = %s", connection));
                        connection.close();
                    }
                    throw throwable;
                }
            }
            log.debug(String.format("close connection, connection = %s", connection));
            connection.close();
        }
        return tableMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ColumnMeta> selectTableMeta(AbstractSqlBuilder abstractSqlBuilder, Connection connection, String tableName, DataBaseType dbType, String tableOwner) throws SQLException {
        List<ColumnMeta> list;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            String sql = abstractSqlBuilder.getDescSql(tableName, tableOwner);
            rs = statement.executeQuery(sql);
            List<ColumnMeta> columnMetas = abstractSqlBuilder.extractColumnMetas(rs);
            if (dbType.equals((Object)DataBaseType.OCEANBASE_ORACLE_MODE)) {
                TableMetaManager.deleteVirtualColumn(connection, tableName, tableOwner, columnMetas);
            }
            list = columnMetas;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)statement);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)statement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteVirtualColumn(Connection connection, String tableName, String tableOwner, List<ColumnMeta> columnMetas) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        try {
            String descSql = String.format("desc %s.%s", tableOwner, tableName);
            statement = connection.createStatement();
            rs = statement.executeQuery(descSql);
            Pattern virtualGenPattern = VIRRUAL_GENERATED;
            block2: while (rs.next()) {
                Matcher virtualGenMatcher;
                if (rs.getString(obOracleExtraColumn) == null || !(virtualGenMatcher = virtualGenPattern.matcher(rs.getString(obOracleExtraColumn))).find()) continue;
                for (ColumnMeta columnMeta : columnMetas) {
                    if (!columnMeta.getName().equalsIgnoreCase(rs.getString(fieldColumn))) continue;
                    columnMetas.remove(columnMeta);
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(statement);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)statement);
    }

    public static void generateSortedPrimaryColumnMetas(TableMeta tableMeta) {
        if (tableMeta.getSortedPrimaryColumnMetas().size() != 0) {
            throw new UnExpectedException("unexpected error");
        }
        tableMeta.getSortedPrimaryColumnMetas().addAll(tableMeta.getPrimaryColumnMetas());
        tableMeta.getSortedPrimaryColumnMetas().sort(Comparator.comparingInt(ColumnMeta::getPkColIdx));
    }
}

