/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.enums.RepairType;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSqlBuilder {
    protected String hint = "";
    protected String selectColumns = "";
    protected String tableName = "";
    protected List<String> primaryKeyConditions = new ArrayList<String>(2);
    protected List<String> maxPrimaryKeyLowCond = new ArrayList<String>(2);
    protected List<String> minPrimaryKeyLowCond = new ArrayList<String>(2);
    protected List<String> userDefinedConditions = new ArrayList<String>(1);
    protected OrderByMethod orderByMethod = OrderByMethod.NOT_ORDER_BY;
    protected Integer offset = null;
    protected Integer limit = null;
    protected Integer batchSize = null;
    protected String tableOwner = "";
    protected String partitionName = "";
    protected List<ColumnMeta> orderByColumns = null;

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getSelectColumns() {
        return this.selectColumns;
    }

    public void setSelectColumns(String selectColumns) {
        this.selectColumns = selectColumns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void addPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.primaryKeyConditions.add(condition);
        }
    }

    public void addUserDefinedCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.userDefinedConditions.add(condition);
        }
    }

    public OrderByMethod getOrderByMethod() {
        return this.orderByMethod;
    }

    public void setOrderByMethod(OrderByMethod orderByMethod) {
        this.orderByMethod = orderByMethod;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public List<ColumnMeta> getOrderByColumns() {
        return this.orderByColumns;
    }

    public void setOrderByColumns(List<ColumnMeta> orderByColumns) {
        this.orderByColumns = orderByColumns;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    public void addMinPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.minPrimaryKeyLowCond.add(condition);
        }
    }

    public void addMaxPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.maxPrimaryKeyLowCond.add(condition);
        }
    }

    public abstract void resolvePkColumn(Connection var1, String var2, List<ColumnMeta> var3, String var4);

    public abstract List<ColumnMeta> extractColumnMetas(ResultSet var1) throws SQLException;

    public abstract String getIndexSql(String var1);

    public abstract String getDescSql(String var1, String var2);

    public abstract String getReadDataSql();

    public abstract String getSplitSql();

    public abstract String getSqlString(Column var1);

    public abstract String generateColumnRepairSql(ColumnMeta var1, String var2, RepairType var3);
}

