/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;

public class MysqlSqlBuilder
extends ObMysqlSqlBuilder {
    @Override
    protected String format() {
        int i;
        this.hint = "";
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        boolean needSubQuery = this.userDefinedConditions.size() > 0;
        StringBuilder builder = new StringBuilder();
        if (needSubQuery) {
            builder.append("SELECT");
            builder.append(" ").append(this.getHint());
            builder.append(" ").append(this.getSelectColumns());
            builder.append(" ").append("FROM");
            builder.append(" ").append("(");
        }
        builder.append("SELECT");
        builder.append(" ").append(this.getHint());
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" ").append("FROM");
        builder.append(" ").append(this.getTableName());
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        builder.append(" force index(PRIMARY) ");
        if (this.primaryKeyConditions.size() > 0) {
            builder.append(" ").append("WHERE");
            for (i = 0; i < this.primaryKeyConditions.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.primaryKeyConditions.get(i)).append(")");
            }
        }
        if (needSubQuery) {
            builder.append(" ").append(")");
            builder.append(" ").append("AS t");
            builder.append(" ").append("WHERE");
            for (i = 0; i < this.userDefinedConditions.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.userDefinedConditions.get(i)).append(")");
            }
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.getOffset()).append(" ,");
            }
            builder.append(" ").append(this.getLimit());
        }
        return builder.toString();
    }
}

