/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.ClusterMeta;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetaHandle {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetaHandle.class);
    private static final String GET_CLUSTER_INFO = "SELECT cluster_name, read_used_quota, write_used_quota, read_size_limit, write_size_limit FROM migration_clusters WHERE cluster_id = ?";

    public static ClusterMeta getClusterMeta(final long clusterId) throws SQLException {
        return (ClusterMeta)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(MainFramework.getMetaDataSource()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(Connection connection) throws SQLException {
                ClusterMeta ret = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement(ClusterMetaHandle.GET_CLUSTER_INFO);
                    preparedStatement.setLong(1, clusterId);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        ClusterMeta clusterMeta = new ClusterMeta();
                        clusterMeta.setClusterId(clusterId);
                        clusterMeta.setClusterName(resultSet.getString("cluster_name"));
                        clusterMeta.setReadUsedQuota(resultSet.getLong("read_used_quota"));
                        clusterMeta.setWriteUsedQuota(resultSet.getLong("write_used_quota"));
                        clusterMeta.setReadSizeLimit(resultSet.getLong("read_size_limit"));
                        clusterMeta.setWriteSizeLimit(resultSet.getLong("write_size_limit"));
                        ret = clusterMeta;
                    }
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly(preparedStatement);
                    throw throwable;
                }
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(preparedStatement);
                return ret;
            }
        });
    }
}

