/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.AbstractDeleteHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDeleteHandler {
    private static final Logger log = LoggerFactory.getLogger(DataDeleteHandler.class);

    public static void delete(final TransRows transRows) throws SQLException {
        if (transRows.getRowCount() == 0) {
            return;
        }
        final TaskMeta taskMeta = transRows.getOwnerTaskMeta();
        DataSourceAdapter dataSourceAdapter = taskMeta.getJobMeta().getSourceAdapter();
        HandlerUtils.runWithRetry(new AbstractDeleteHandler(dataSourceAdapter){

            @Override
            public Object run(Connection connection) throws SQLException {
                for (int i = transRows.getBatchRowsCount() - 1; i >= 0; --i) {
                    DataDeleteHandler.deleteBatchRows(connection, transRows.getBatchRows(i), taskMeta);
                    if (transRows.getBatchRows(i).getRowCount() <= 0) continue;
                    log.debug("{}: {} Delete {} Rows.[{} - {}]", new Object[]{this.dataSourceAdapter.getDataSourceInfo().getDataSourceName(), transRows.getBatchRows(i).getTableMeta().getName(), transRows.getBatchRows(i).getRowCount(), transRows.getBatchRows(i).getMinPrimaryKey().toSqlString(), transRows.getBatchRows(i).getMaxPrimaryKey().toSqlString()});
                }
                return null;
            }
        });
    }

    private static String getDeleteSql(TableMeta phyTableMeta, int deleteBatchSize) {
        String deleteSql = String.format("DELETE /*+ index(%s primary) */ FROM `%s` WHERE ", phyTableMeta.getName(), phyTableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(phyTableMeta.getSortedPrimaryColumnMetas(), deleteBatchSize);
        return deleteSql;
    }

    private static void deleteBatchRows(Connection connection, BatchRows batchRows, TaskMeta taskMeta) throws SQLException {
        if (batchRows.getRowCount() > 0) {
            int deleteBatchSize = taskMeta.getJobMeta().getDeleteBatchSize();
            TableMeta phyTableMeta = taskMeta.getJobMeta().getSourceTableMeta(batchRows.getTableMeta().getName());
            String deleteSql = DataDeleteHandler.getDeleteSql(phyTableMeta, deleteBatchSize);
            if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
                log.info("getBatchDeleteSql = " + deleteSql);
            }
            List<ColumnMeta> multiGetColumnMetas = phyTableMeta.getSortedPrimaryColumnMetas();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(deleteSql);
                List<Row> rows = batchRows.getRows();
                int paramIndex = 0;
                int pkColumnCount = phyTableMeta.getSortedPrimaryColumnMetas().size();
                int loopCnt = rows.size();
                if (loopCnt % deleteBatchSize != 0) {
                    loopCnt += deleteBatchSize - loopCnt % deleteBatchSize;
                }
                for (int i = 0; i < loopCnt; ++i) {
                    if (i >= rows.size()) {
                        for (int keyIdx = 0; keyIdx < pkColumnCount; ++keyIdx) {
                            preparedStatement.setNull(++paramIndex, 12);
                        }
                    } else {
                        int keyIdx;
                        Row row = batchRows.getRow(i);
                        if (row.isDirtyRow()) {
                            for (keyIdx = 0; keyIdx < pkColumnCount; ++keyIdx) {
                                preparedStatement.setNull(++paramIndex, 12);
                            }
                        } else {
                            for (keyIdx = 0; keyIdx < pkColumnCount; ++keyIdx) {
                                SqlUtils.setPsParam(preparedStatement, ++paramIndex, row.getColumnList().get(multiGetColumnMetas.get(keyIdx).getColIdx()));
                            }
                        }
                    }
                    if (i % deleteBatchSize != deleteBatchSize - 1) continue;
                    preparedStatement.executeUpdate();
                    preparedStatement.clearParameters();
                    paramIndex = 0;
                }
            }
            catch (SQLException e) {
                log.warn("failed to delete batch rows, taskMeta = " + taskMeta, (Throwable)e);
                throw e;
            }
            finally {
                DbUtils.closeQuietly((Statement)preparedStatement);
            }
        }
        if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info(String.format("table[%s] getRowCount() = 0", batchRows.getTableMeta().getName()));
        }
    }
}

