/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.configure.JoinTableInfo;
import com.oceanbase.tools.migrator.common.configure.SubTableInfo;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.RowUtils;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.handler.MultiGetJoinHandler;
import com.oceanbase.tools.migrator.core.handler.MultiGetSubHandler;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReadHandler {
    private static final Logger log = LoggerFactory.getLogger(DataReadHandler.class);

    public static TransRows scan(final TaskMeta taskMeta, final String tableName, DataSourceAdapter dataSourceAdapter, final PrimaryKey lowerBound, final PrimaryKey upperBound, final int scanRowCount, final String hint) throws SQLException {
        if (lowerBound == null || upperBound == null) {
            throw new UnExpectedException("invalid bound" + lowerBound + upperBound);
        }
        final TableMeta tableMeta = taskMeta.getJobMeta().getPrimaryTableMeta();
        TransRows transRows = null;
        transRows = (TransRows)HandlerUtils.runWithRetry(new AbstractReadHandler(dataSourceAdapter){

            @Override
            public Object run(Connection connection) throws SQLException {
                TransRows retTransRows = new TransRows();
                retTransRows.setOwnerTaskMeta(taskMeta);
                DataBaseType dbType = this.dataSourceAdapter.getDataBaseType();
                String readDataSql = DataReadHandler.getReadSql(tableMeta, tableName, taskMeta.getJobMeta(), taskMeta, lowerBound, upperBound, hint);
                BatchRows mainBatchRows = DataReadHandler.getBatchRows(connection, readDataSql, dbType);
                mainBatchRows.setTableMeta(tableMeta);
                mainBatchRows.setScanRowCount(scanRowCount);
                if (taskMeta.getJobMeta().getJoinTables().size() == 0) {
                    retTransRows.addBatchRows(mainBatchRows);
                    for (SubTableInfo subTableInfo : taskMeta.getJobMeta().getSubTables()) {
                        BatchRows subBatchRow = MultiGetSubHandler.multiGetSubBatchRows(connection, mainBatchRows, subTableInfo);
                        retTransRows.addBatchRows(subBatchRow);
                    }
                } else if (taskMeta.getJobMeta().getSubTables().size() == 1 && taskMeta.getJobMeta().getJoinTables().size() == 1) {
                    retTransRows.addReadRows(mainBatchRows);
                    BatchRows joinBatchRow = MultiGetJoinHandler.multiGetJoinBatchRows(connection, mainBatchRows, taskMeta.getJobMeta().getJoinTables().get(0));
                    retTransRows.addReadRows(joinBatchRow);
                    SubTableInfo subTableInfo = taskMeta.getJobMeta().getSubTables().get(0);
                    BatchRows subBatchRow = MultiGetSubHandler.multiGetSubBatchRows(connection, joinBatchRow, subTableInfo);
                    retTransRows.addBatchRows(subBatchRow);
                } else if (taskMeta.getJobMeta().getSubTables().size() == 0 && taskMeta.getJobMeta().getJoinTables().size() == 1) {
                    retTransRows.addBatchRows(mainBatchRows);
                } else {
                    throw new DefinedException(ErrorType.NOT_SUPPORT, "Join Table Only support one subTable one join,current subTable has" + taskMeta.getJobMeta().getSubTables().size() + "joinTable has " + taskMeta.getJobMeta().getJoinTables().size());
                }
                if (retTransRows.getRowCount() > 0) {
                    log.debug("{}: {} ScanRead {} Rows. [{} - {}]", new Object[]{this.dataSourceAdapter.getDataSourceInfo().getDataSourceName(), tableName, retTransRows.getRowCount(), retTransRows.getMinPrimaryKey().toSqlString(), retTransRows.getMaxPrimaryKey().toSqlString()});
                }
                return retTransRows;
            }
        });
        return transRows;
    }

    public static String getReadSql(TableMeta tableMeta, String tableName, JobMeta jobMeta, TaskMeta taskMeta, PrimaryKey lowerBound, PrimaryKey upperBound, String hint) {
        AbstractSqlBuilder builder = SqlBuilderFactory.getSqlBuilder(jobMeta);
        builder.setSelectColumns(tableMeta.getColumnListStr());
        builder.setTableName(tableName);
        builder.setTableOwner(jobMeta.getSourceTableOwner());
        builder.addUserDefinedCondition(jobMeta.getMigrateRule());
        builder.setPartitionName(taskMeta.getPartitionName());
        builder.addUserDefinedCondition(jobMeta.getDateConditionExpr());
        if (taskMeta.getJobMeta().getSubTables().size() == 0 && taskMeta.getJobMeta().getJoinTables().size() == 1) {
            String conditionJoinColumn;
            String primaryJoinColumn;
            JoinTableInfo joinTableInfo = taskMeta.getJobMeta().getJoinTables().get(0);
            if (!joinTableInfo.getJoinColumn().contains("@")) {
                conditionJoinColumn = primaryJoinColumn = joinTableInfo.getJoinColumn();
            } else {
                primaryJoinColumn = joinTableInfo.getJoinColumn().split("@")[0];
                conditionJoinColumn = joinTableInfo.getJoinColumn().split("@")[1];
            }
            String joinTableName = tableMeta.getDataBaseType() == DataBaseType.ORACLE || tableMeta.getDataBaseType() == DataBaseType.OCEANBASE_ORACLE_MODE ? joinTableInfo.getTableName() : String.format("`%s`", joinTableInfo.getTableName());
            String joinRule = joinTableInfo.getWhereCond() == null || joinTableInfo.getWhereCond().equals("") ? "EXISTS (select 1 from " + joinTableName + " j_a where j_a." + conditionJoinColumn + "=t." + primaryJoinColumn + " limit 1)" : "EXISTS (select 1 from " + joinTableName + " j_a where j_a." + conditionJoinColumn + "=t." + primaryJoinColumn + " and " + joinTableInfo.getWhereCond() + " limit 1)";
            builder.addUserDefinedCondition(joinRule);
        }
        if (tableMeta.getDataBaseType().equals((Object)DataBaseType.ORACLE)) {
            builder.setBatchSize(jobMeta.getLogicTableConfig().getReaderBatchSize());
            builder.setHint(hint);
            builder.addMinPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(tableMeta, lowerBound));
            builder.addMaxPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(tableMeta, upperBound));
        } else {
            if (tableMeta.getDataBaseType().equals((Object)DataBaseType.OCEANBASE_ORACLE_MODE)) {
                builder.setBatchSize(jobMeta.getLogicTableConfig().getReaderBatchSize());
            }
            builder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(tableMeta, lowerBound));
            builder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(tableMeta, upperBound));
        }
        builder.setOrderByColumns(tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
            log.info("getReadDataSql = " + builder.getReadDataSql());
        }
        return builder.getReadDataSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchRows getBatchRows(Connection connection, String sql, DataBaseType dbType) throws SQLException {
        BatchRows batchRows;
        if (log.isDebugEnabled()) {
            log.debug(String.format("execute sql, %s", sql));
        }
        BatchRows batchRows2 = new BatchRows();
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                Row row = RowUtils.getRow(rs, dbType);
                if (row == null) continue;
                batchRows2.addRow(row);
            }
            batchRows = batchRows2;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)statement);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)statement);
        return batchRows;
    }
}

