/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.configure.DirtyRowAction;
import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.configure.TableConfig;
import com.oceanbase.tools.migrator.common.configure.Utils;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.common.enums.PrimaryKeyChoice;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.framework.MainFramework;
import com.oceanbase.tools.migrator.task.CheckMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class LogicTableConfigHandle {
    private static final String GET_LOGIC_TABLE_INFO_SQL = "select migrate_rule, table_config, check_mode, enable_imprecise_save_point, max_allowed_dirty_row_count, allowed_dirty_columns, dirty_row_action, migration_insert_action, migrate_date_column, migrate_date_format, read_batch_size, write_batch_size, sub_task_batch_size, generator_batch_size, job_schedule_interval_minute, force_primary_choice, enable_column_auto_repair  from migration_logictables where logictable_id = ?";

    public static LogicTableConfig getLogicTableConfig(final Long logicTableId, final Map<String, String> shardingParametersMap, final String dateStart, final String dateEnd) throws SQLException {
        final LogicTableConfig logicTableConfig = new LogicTableConfig();
        HandlerUtils.runWithRetry(new AbstractReadHandler(MainFramework.getMetaDataSource()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement(LogicTableConfigHandle.GET_LOGIC_TABLE_INFO_SQL);
                    preparedStatement.setLong(1, logicTableId);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        logicTableConfig.setMigrateRule(Utils.instantiateMigrateRule(resultSet.getString("migrate_rule"), dateStart, dateEnd));
                        TableConfig tc = TableConfig.load(resultSet.getString("table_config"), shardingParametersMap, dateStart, dateEnd);
                        if (tc != null) {
                            logicTableConfig.setTableConfig(tc);
                        }
                        logicTableConfig.setCheckMode(CheckMode.valueOf(resultSet.getString("check_mode")));
                        logicTableConfig.setEnableImpreciseSavePoint(Boolean.valueOf(resultSet.getString("enable_imprecise_save_point")));
                        logicTableConfig.setMaxAllowedDirtyRowCount(resultSet.getLong("max_allowed_dirty_row_count"));
                        String dirtyColumnsStr = resultSet.getString("allowed_dirty_columns");
                        if (dirtyColumnsStr != null && dirtyColumnsStr.length() > 0) {
                            for (String dirtyColumn : dirtyColumnsStr.split(",")) {
                                logicTableConfig.addAllowedDirtyColumns(dirtyColumn);
                            }
                        }
                        logicTableConfig.setDirtyRowAction(DirtyRowAction.valueOf(resultSet.getString("dirty_row_action")));
                        logicTableConfig.setMigrationInsertAction(MigrationInsertAction.valueOf(resultSet.getString("migration_insert_action")));
                        logicTableConfig.setMigrateDateColumn(resultSet.getString("migrate_date_column"));
                        logicTableConfig.setMigrateDateFormat(resultSet.getString("migrate_date_format"));
                        logicTableConfig.setReaderBatchSize(resultSet.getInt("read_batch_size"));
                        logicTableConfig.setWriterBatchSize(resultSet.getInt("write_batch_size"));
                        logicTableConfig.setSubTaskBatchSize(resultSet.getInt("sub_task_batch_size"));
                        logicTableConfig.setGeneratorBatchSize(resultSet.getInt("generator_batch_size"));
                        logicTableConfig.setScheduleIntervalMinute(resultSet.getInt("job_schedule_interval_minute"));
                        if (resultSet.getString("force_primary_choice") != null) {
                            logicTableConfig.setPrimaryKeyChoice(PrimaryKeyChoice.valueOf(resultSet.getString("force_primary_choice")));
                        }
                    } else {
                        throw new DefinedException(ErrorType.INVALID_PARAMETER, String.format("logic table not found, logictable_id=[%d]", logicTableId));
                    }
                    logicTableConfig.setEnableColumnAutoRepair(resultSet.getBoolean("enable_column_auto_repair"));
                    if (logicTableConfig.getSubTaskBatchSize() < logicTableConfig.getGeneratorBatchSize()) {
                        throw new DefinedException(ErrorType.INVALID_PARAMETER, String.format("generatorBatchSize great than subTaskBatchSize,generatorBatchSize=[%d],subTaskBatchSize=[%d]", logicTableConfig.getGeneratorBatchSize(), logicTableConfig.getSubTaskBatchSize()));
                    }
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly(preparedStatement);
                    throw throwable;
                }
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(preparedStatement);
                return null;
            }
        });
        return logicTableConfig;
    }
}

