/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.common.enums.TaskStatus;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.core.tunnel.BufferTunnel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTunnel
extends BufferTunnel<TaskMeta> {
    private static final Logger log = LoggerFactory.getLogger(TaskTunnel.class);
    private final List<TaskMeta> runningTasks = new LinkedList<TaskMeta>();

    public TaskTunnel(JobMeta jobMeta) {
        super(jobMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskMeta takeInternal() throws InterruptedException {
        TaskMeta taskMeta = (TaskMeta)super.takeInternal();
        if (taskMeta != null) {
            taskMeta.setTaskStatus(TaskStatus.RUNNING);
            log.info(String.format("task is ready to run, taskMeta = %s", taskMeta.toString()));
            List<TaskMeta> list = this.runningTasks;
            synchronized (list) {
                this.runningTasks.add(taskMeta);
            }
        }
        return taskMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report() {
        List<TaskMeta> list = this.runningTasks;
        synchronized (list) {
            Iterator<TaskMeta> taskIter = this.runningTasks.iterator();
            while (taskIter.hasNext()) {
                TaskMeta taskMeta = taskIter.next();
                try {
                    taskMeta.checkFinished();
                    this.jobMeta.storeTaskMeta(taskMeta);
                    if (!taskMeta.getTaskStatus().isTaskFinished()) continue;
                    taskIter.remove();
                }
                catch (Exception e) {
                    log.warn("fail to update task", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() && this.runningTasks.isEmpty();
    }
}

