/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.dto.HistoryJob;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.JobStatus;
import com.oceanbase.tools.migrator.common.exception.JobNotFoundException;
import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class HistoryJobDao {
    private static final Integer MAX_ERROR_LENTH = 1000;
    private static final String UPDATE_JOB_STATUS_SQL = "UPDATE history_job SET job_status = ?, worker_ip = ? WHERE id = ?";
    private static final String UPDATE_JOB_RUNNING_SQL = "UPDATE history_job SET job_status = 'RUNNING', worker_ip = ?, gmt_start = now(), gmt_finish = null WHERE id = ?";
    private static final String UPDATE_JOB_SUCCESS_SQL = "UPDATE history_job SET job_status = 'SUCCESS', gmt_finish = now(), error_type = null, error_msg = null WHERE id = ?";
    private static final String UPDATE_JOB_FAILED_SQL = "UPDATE history_job SET job_status = 'FAILED', gmt_finish = now(), error_type = ?, error_msg = ? WHERE id = ?";
    private static final String UPDATE_RUNNING_JOB_RUNNABLE_SQL = "UPDATE history_job SET job_status = 'RUNNABLE' WHERE worker_ip = ? and job_status = 'RUNNING'";
    private static final String QUERY_JOB_SQL = "SELECT id, job_status, job_type, table_id, source_ds, target_ds, print_sql_trace, date_start, date_end, child_jobs, logictable_id, source_table_name, target_table_name, task_generator_id, parameter, sharding_parameter FROM history_job WHERE id = ?";
    private static final String UPDATE_JOB_GENERATOR_SQL = "UPDATE history_job SET task_generator_id = ? WHERE id = ?";

    public static int updateRunningJobToRunnable(Connection connection, String workerIp) throws SQLException {
        return DaoUtils.update(connection, UPDATE_RUNNING_JOB_RUNNABLE_SQL, workerIp);
    }

    public static void updateJobStatusAndIp(Connection connection, JobStatus status, String workerIp, String jobId) throws SQLException {
        DaoUtils.update(connection, UPDATE_JOB_STATUS_SQL, status.name(), workerIp, jobId);
    }

    public static void updateJobRunning(Connection connection, String workerIp, String jobId) throws SQLException {
        DaoUtils.update(connection, UPDATE_JOB_RUNNING_SQL, workerIp, jobId);
    }

    public static void updateJobSuccess(Connection connection, String jobId) throws SQLException {
        DaoUtils.update(connection, UPDATE_JOB_SUCCESS_SQL, jobId);
    }

    public static void updateJobFailed(Connection connection, ErrorType errorType, String message, String jobId) throws SQLException {
        if (message.length() > MAX_ERROR_LENTH) {
            message = message.substring(0, MAX_ERROR_LENTH);
        }
        DaoUtils.update(connection, UPDATE_JOB_FAILED_SQL, errorType.name(), message, jobId);
    }

    public static HistoryJob queryJob(Connection connection, String jobId) throws SQLException, JobNotFoundException {
        List<Map<String, Object>> result = DaoUtils.query(connection, QUERY_JOB_SQL, jobId);
        if (result.isEmpty()) {
            throw new JobNotFoundException(jobId);
        }
        return new HistoryJob(result.get(0));
    }

    public static void updateJobGenerator(Connection connection, String generatorId, String jobId) throws SQLException {
        DaoUtils.update(connection, UPDATE_JOB_GENERATOR_SQL, generatorId, jobId);
    }
}

