/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.exception.TaskGeneratorNotFoundException;
import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class HistoryTaskGeneratorDao {
    private static final String SAVE_TASK_GENERATOR_SQL = "REPLACE INTO history_task_generator (id, generator_type, generator_status, task_count, generator_savepoint, generator_partition_savepoint) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String QUERY_TASK_GENERATOR_SQL = "SELECT id, generator_type, generator_status, task_count, generator_savepoint, generator_partition_savepoint FROM  history_task_generator WHERE id = ?";

    public static void saveTaskGenerator(Connection connection, TaskGenerator taskGenerator) throws SQLException {
        Object[] sqlParam = new Object[]{taskGenerator.getId(), taskGenerator.getGeneratorType().name(), taskGenerator.getGeneratorStatus().name(), taskGenerator.getTaskCount(), taskGenerator.getGeneratorSavePoint() == null ? null : taskGenerator.getGeneratorSavePoint().toSqlString(), taskGenerator.getGeneratorPartitionSavepoint()};
        DaoUtils.update(connection, SAVE_TASK_GENERATOR_SQL, sqlParam);
    }

    public static TaskGenerator queryTaskGenerator(Connection connection, String taskGeneratorId, String jobId) throws SQLException, TaskGeneratorNotFoundException {
        List<Map<String, Object>> result = DaoUtils.query(connection, QUERY_TASK_GENERATOR_SQL, taskGeneratorId);
        if (result.isEmpty()) {
            throw new TaskGeneratorNotFoundException(jobId, taskGeneratorId);
        }
        return new TaskGenerator(result.get(0));
    }
}

