/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.dto.WorkerCommand;
import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HistoryWorkerCommandDao {
    private static final String FETCH_COMMANDS_SQL = "SELECT id, command_type, command_param FROM history_worker_command WHERE worker_ip = ? AND command_status = 'PENDING' ORDER BY ID LIMIT 100 FOR UPDATE";
    private static final String CONSUME_COMMAND_SQL = "UPDATE history_worker_command SET command_status = 'DONE' WHERE id = ?";

    public static List<WorkerCommand> batchFetchCommands(Connection connection, String workerIp) throws SQLException {
        Object[] sqlParam = new String[]{workerIp};
        List<Map<String, Object>> result = DaoUtils.query(connection, FETCH_COMMANDS_SQL, sqlParam);
        return result.stream().map(WorkerCommand::new).collect(Collectors.toList());
    }

    public static void consumeCommand(Connection connection, String commandId) throws SQLException {
        connection.setAutoCommit(false);
        DaoUtils.update(connection, CONSUME_COMMAND_SQL, commandId);
    }
}

