/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.dto.TableRowLimit;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class MigrationTablesDao {
    private static final String QUERY_LIMIT_SQL = "SELECT read_row_count_limit, write_row_count_limit FROM migration_tables WHERE table_id = ?";
    private static final String UPDATE_DATE_MIGRATED_SQL = "UPDATE migration_tables SET date_migrated = ?,  gmt_modify = now() WHERE table_id = ?";
    private static final String UPDATE_DATE_DELETED_SQL = "UPDATE migration_tables SET date_deleted = ? , gmt_modify = now() WHERE table_id = ?";
    private static final String UPDATE_DATE_SIZE_INFO_SQL = "UPDATE migration_tables SET total_row_count = ? , data_size = ?, required_size = ? WHERE table_id = ?";

    public static TableRowLimit queryTableRowLimit(Connection connection, long tableId) throws SQLException {
        List<Map<String, Object>> result = DaoUtils.query(connection, QUERY_LIMIT_SQL, tableId);
        if (result.isEmpty()) {
            throw new RuntimeException(String.format("migration table not found, tableId: %d", tableId));
        }
        int readRowCountLimit = (Integer)result.get(0).get("read_row_count_limit");
        int writeRowCountLimit = (Integer)result.get(0).get("write_row_count_limit");
        return new TableRowLimit(readRowCountLimit, writeRowCountLimit);
    }

    public static void updateTableDateMigrated(Connection connection, String dateStr, long tableId) throws SQLException {
        DaoUtils.update(connection, UPDATE_DATE_MIGRATED_SQL, dateStr, tableId);
    }

    public static void updateTableDateDeleted(Connection connection, String dateStr, long tableId) throws SQLException {
        DaoUtils.update(connection, UPDATE_DATE_DELETED_SQL, dateStr, tableId);
    }

    public static void updateTableSizeInfo(Connection connection, TableSizeInfo tableSizeInfo, long tableId) throws SQLException {
        DaoUtils.update(connection, UPDATE_DATE_SIZE_INFO_SQL, tableSizeInfo.getTableRowCount(), tableSizeInfo.getDataSize(), tableSizeInfo.getRequiredSize(), tableId);
    }
}

