/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.google.common.util.concurrent.RateLimiter;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.calculator.IPartIdCalculator;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceAdapter
implements DataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceAdapter.class);
    protected DataSourceInfo dataSourceInfo;
    private RateLimiter rateLimiter = null;
    private int rate = -1;
    private static final int MIN_CONNECTION_COUNT = 10;
    private static final int MAX_CONNECTION_COUNT = 100;
    protected String cpuLimitDsName = "";
    protected String memLimitDsName = "";

    public AbstractDataSourceAdapter(DataSourceInfo dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
    }

    protected final void acquire() {
        while (this.rate == 0) {
            try {
                int sleepTime = MainFramework.getUpdateConfigInterval();
                log.info(String.format("rate control : rate = 0 , sleep for %d seconds", sleepTime));
                Thread.sleep((long)sleepTime * 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.rateLimiter != null) {
            this.rateLimiter.acquire();
        }
    }

    protected final void updateRateLimiter(int rate) {
        this.rate = rate;
        if (rate > 0) {
            if (this.rateLimiter == null) {
                this.rateLimiter = RateLimiter.create((double)rate);
            } else {
                this.rateLimiter.setRate((double)rate);
            }
        } else {
            this.rateLimiter = null;
        }
    }

    @Override
    public boolean isValid() {
        if (this.dataSourceInfo.getConnectionCount() < 10) {
            throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, String.format("init datasource failed, invalid parameter connection count = %d", this.dataSourceInfo.getConnectionCount()));
        }
        if (this.dataSourceInfo.getConnectionCount() > 100) {
            throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, String.format("init datasource failed, invalid parameter connection count = %d", this.dataSourceInfo.getConnectionCount()));
        }
        return true;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    @Override
    public String getDbType() {
        return this.dataSourceInfo.getDbType();
    }

    @Override
    public DataBaseType getDataBaseType() {
        return this.dataSourceInfo.getDataBaseType();
    }

    @Override
    public Boolean isPartitionTable(String tableName) throws SQLException {
        return false;
    }

    @Override
    public IPartIdCalculator getPartitionIdCalculator(String tableName) throws SQLException {
        return null;
    }

    @Override
    public List<String> getPartitionNames(String tableName) throws SQLException {
        return new ArrayList<String>();
    }

    @Override
    public String getSchema() {
        return this.dataSourceInfo.getDatabaseName();
    }

    @Override
    public Connection getConnectionForWrite(String sql, Row row) throws SQLException {
        return this.getConnectionForWrite();
    }

    @Override
    public Connection getSysConnection() throws SQLException {
        return this.getConnection();
    }

    @Override
    public String getCpuLimitDsName() {
        return this.cpuLimitDsName;
    }

    @Override
    public String getMemLimitDsName() {
        return this.memLimitDsName;
    }

    @Override
    public TableSizeInfo getSourceTableSizeInfo(String tableName) throws SQLException {
        return new TableSizeInfo();
    }

    @Override
    public void closeDataSource() {
    }
}

