/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.ExceptionSorter;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObOracleExceptionSorter;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObDataSourceAdapter
extends AbstractDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractObDataSourceAdapter.class);
    private long lastWriteValidTime = 0L;
    private long lastDeleteValidTime = 0L;
    private int sleepTime = 50;
    public String obVersion;
    protected DruidDataSource obSysDataSourceByObProxy = null;
    private static final String QUERY_TENANT_ID = "SELECT tenant_id FROM oceanbase.__all_tenant WHERE tenant_name = '%s'";
    private static final String QUERY_MEMSTORE_INFO = "SELECT mem.IP, mem.TOTAL, mem.FREEZE_TRIGGER FROM oceanbase.gv$memstore AS mem where mem.tenant_id = '%s' AND (mem.TOTAL >= mem.FREEZE_TRIGGER * 1.05)";
    private static final String QUERY_MEMSTORE_INFO_OB4X = "SELECT mem.SVR_IP, mem.MEMSTORE_USED, mem.FREEZE_TRIGGER FROM oceanbase.gv$ob_memstore AS mem where mem.tenant_id = '%s' AND (mem.MEMSTORE_USED >= mem.FREEZE_TRIGGER * 1.05);";
    private static final String QUERY_CPU_PERCENT_INFO = "SELECT cpu_usage.svr_ip svr_ip, round(cpu_usage.value * 100 / cpu_limit.value) cpu_percent FROM oceanbase.gv$sysstat cpu_usage, oceanbase.gv$sysstat cpu_limit WHERE cpu_usage.CON_ID = '%s' AND cpu_limit.CON_ID = '%s' AND cpu_usage.name = 'cpu usage' AND cpu_limit.name = 'max cpus' AND cpu_usage.svr_ip = cpu_limit.svr_ip HAVING cpu_percent > 0";
    private static final String QUERY_TABLE_INFO_SQL = "SELECT /*+ read_consisitency(weak), query_timeout(60000000) */\nSUM(row_count) AS row_count, SUM(required_size) AS required_size, SUM(data_size) AS data_size\nFROM %s a, %s b, %s d\nWHERE a.role = 1 AND a.tenant_id >= 1000 AND a.table_id = b.table_id AND\nb.table_name = '%s' AND a.tenant_id = '%s' AND\nb.database_id = d.database_id AND d.database_name = '%s' GROUP BY a.table_id";

    public AbstractObDataSourceAdapter(DataSourceInfo dataSourceInfo) {
        super(dataSourceInfo);
    }

    protected abstract boolean isAllowWrite(Connection var1) throws SQLException;

    protected abstract boolean isAllowDelete(Connection var1) throws SQLException;

    protected DruidDataSource configDataSourceByObProxy(DataSourceInfo conf) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        if (conf.getPassword() != null) {
            properties.setProperty("password", conf.getPassword());
        }
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oceanbase://%s/%s?useUnicode=true&characterEncoding=utf-8", conf.getObProxy(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
        properties.setProperty("validationQuery", "select 1");
        DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        ArrayList<String> initSql = new ArrayList<String>();
        initSql.add("set @@ob_org_cluster_id = 2147473648");
        druidDataSource.setConnectionInitSqls(initSql);
        druidDataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
        return druidDataSource;
    }

    protected DruidDataSource configSysDataSourceByObProxy(DataSourceInfo conf) {
        try {
            Properties properties = new Properties();
            properties.setProperty("username", conf.getSysFullUserName());
            if (conf.getEncryptSysPassword() != null) {
                properties.setProperty("password", conf.getEncryptSysPassword());
            }
            properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
            properties.setProperty("maxWait", "10000");
            properties.setProperty("getConnectionTimeout", "10000");
            properties.setProperty("minIdle", "0");
            String url = String.format("jdbc:oceanbase://%s/%s?useUnicode=true&characterEncoding=utf-8", conf.getObProxy(), conf.getSysDatabaseName());
            properties.setProperty("url", url);
            properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
            properties.setProperty("initialSize", "0");
            properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
            properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
            properties.setProperty("validationQuery", "select 1");
            DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
            ArrayList<String> initSql = new ArrayList<String>();
            initSql.add("set @@ob_org_cluster_id = 2147473648");
            druidDataSource.setConnectionInitSqls(initSql);
            druidDataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
            druidDataSource.init();
            this.updateRateLimiter(conf.getRateLimit());
            return druidDataSource;
        }
        catch (Exception e) {
            log.warn(String.format("fail to init oceanbaseV10 SYS dataSource, ds=%s, conf=%s", this.dataSourceInfo.getDataSourceName(), conf), (Throwable)e);
            return null;
        }
    }

    protected DataSource getSysDataSource() {
        return this.obSysDataSourceByObProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTenantIdInfo(DataSourceInfo dataSourceInfo, Connection connection) throws SQLException {
        if (dataSourceInfo == null) {
            return;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(this.getQueryTenantIdSql());
            rs = ps.executeQuery();
            if (rs.next()) {
                dataSourceInfo.setTenantId(rs.getLong("tenant_id"));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)ps);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
    }

    protected void waitAvailable(Connection connection) throws SQLException {
        while (System.currentTimeMillis() - this.lastWriteValidTime > 1000L * (long)MainFramework.getWritableCheckInterval()) {
            if (!this.isAllowWrite(connection)) {
                try {
                    log.info(String.format("write is not allowed, sleep for %d seconds", this.sleepTime));
                    Thread.sleep((long)this.sleepTime * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.lastWriteValidTime = System.currentTimeMillis();
        }
    }

    protected void waitDeleteAvailable(Connection connection) throws SQLException {
        while (System.currentTimeMillis() - this.lastDeleteValidTime > 1000L * (long)MainFramework.getDeletableCheckInterval()) {
            if (!this.isAllowDelete(connection)) {
                try {
                    int sleepSeconds = new Random().nextInt(10) + 10;
                    log.info(String.format("delete is not allowed, sleep for %d seconds", sleepSeconds));
                    Thread.sleep(sleepSeconds * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.lastDeleteValidTime = System.currentTimeMillis();
        }
    }

    protected String getTenantMemQuerySql() {
        if (this.isOB4x()) {
            return String.format(QUERY_MEMSTORE_INFO_OB4X, this.dataSourceInfo.getTenantId());
        }
        return String.format(QUERY_MEMSTORE_INFO, this.dataSourceInfo.getTenantId());
    }

    protected String getTenantCpuQuerySql() {
        return String.format(QUERY_CPU_PERCENT_INFO, this.dataSourceInfo.getTenantId(), this.dataSourceInfo.getTenantId());
    }

    protected String getQueryTenantIdSql() {
        return String.format(QUERY_TENANT_ID, this.dataSourceInfo.getTenantName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableSizeInfo queryTableRowCount(Connection connection, String tableName, String dbName, Long tenantId) throws SQLException {
        TableSizeInfo tableSizeInfo = new TableSizeInfo();
        String queryRowCountSql = this.generateQueryRowCountSql(connection, tableName, dbName, tenantId);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(queryRowCountSql);
            rs = ps.executeQuery();
            if (rs.next()) {
                tableSizeInfo.setTableRowCount(rs.getLong("row_count"));
                tableSizeInfo.setDataSize(rs.getLong("data_size"));
                tableSizeInfo.setRequiredSize(rs.getLong("required_size"));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)ps);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
        return tableSizeInfo;
    }

    @Override
    public void closeDataSource() {
        if (this.obSysDataSourceByObProxy != null) {
            this.obSysDataSourceByObProxy.close();
        }
    }

    private String generateQueryRowCountSql(Connection connection, String tableName, String dbName, Long tenantId) throws SQLException {
        if (this.isOB4x()) {
            return String.format("select TABLE_ROWS, DATA_LENGTH from `information_schema`.`tables` where table_schema=%s  and table_name=%s;", dbName, tableName);
        }
        String allTableName = "__all_table";
        String allDatabaseName = "__all_database";
        String allMetaTableName = "__all_meta_table";
        String obVersion = AbstractObDataSourceAdapter.queryOBVersion(connection);
        if (AbstractObDataSourceAdapter.compareVersions(obVersion, "2.2.0") >= 0) {
            allTableName = "__all_virtual_table";
            allDatabaseName = "__all_virtual_database";
        }
        if (AbstractObDataSourceAdapter.compareVersions(obVersion, "2.0.0") >= 0) {
            allMetaTableName = "__all_virtual_meta_table";
        }
        return String.format(QUERY_TABLE_INFO_SQL, allMetaTableName, allTableName, allDatabaseName, tableName, tenantId, dbName);
    }

    /*
     * Exception decompiling
     */
    public static String queryOBVersion(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String parseObVersionComment(String obVersionComment) {
        Validate.notBlank((CharSequence)obVersionComment);
        String[] obVersion = obVersionComment.split("\\s+");
        if (obVersion == null) {
            throw new NullPointerException("version_comment cannot be empty");
        }
        if (obVersion.length < 4) {
            throw new IllegalArgumentException("version_comment get failed");
        }
        return obVersion[1];
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        log.info("set sleep time = {}", (Object)sleepTime);
    }

    public static int compareVersions(String version1, String version2) {
        Validate.notEmpty((CharSequence)version1, (String)"parameter version1 may not be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)version2, (String)"parameter version2 may not be empty", (Object[])new Object[0]);
        String[] version1Parts = version1.split("\\.");
        String[] version2Parts = version2.split("\\.");
        int maxLength = Math.max(version1Parts.length, version2Parts.length);
        for (int i = 0; i < maxLength; ++i) {
            Integer version2Part;
            Integer version1Part = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0;
            int result = version1Part.compareTo(version2Part = Integer.valueOf(i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean isOB4x() {
        return AbstractObDataSourceAdapter.compareVersions(this.obVersion, "4.0.0") > 0;
    }
}

