/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.fastjson.JSON;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.DataSourceFactory;
import com.oceanbase.tools.migrator.framework.MainFramework;
import com.oceanbase.tools.migrator.framework.MetaHandler;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);

    public DataSourceAdapter initMetaDb(String metaDbName, String configFilePath) {
        DataSourceAdapter dataSourceAdapter = null;
        try {
            String context = IOUtils.toString((InputStream)MainFramework.class.getClassLoader().getResourceAsStream(configFilePath));
            DataSourceInfo dataSourceInfo = (DataSourceInfo)JSON.parseObject((String)context, DataSourceInfo.class);
            dataSourceInfo.setDataSourceName(metaDbName);
            dataSourceAdapter = DataSourceFactory.getMetaDatasource(dataSourceInfo);
            log.info(String.format("success to init metaDB datasource, dataSourceName = %s, dbName: %s user: %s", metaDbName, dataSourceInfo.getDatabaseName(), dataSourceInfo.getFullUserName()));
        }
        catch (Exception e) {
            log.warn(String.format("failed to init metaDB dataSource, name=%s", metaDbName), (Throwable)e);
            System.exit(-1);
        }
        return dataSourceAdapter;
    }

    public DataSourceAdapter getDataSource(String dataSourceName) {
        DataSourceAdapter dataSourceAdapter;
        try {
            DataSourceInfo dataSourceInfo = MetaHandler.getDataSourceConfigFromDB(dataSourceName);
            dataSourceAdapter = DataSourceFactory.getDataSource(dataSourceInfo);
        }
        catch (Exception e) {
            log.warn(String.format("failed to init dataSource, name=%s", dataSourceName), (Throwable)e);
            throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, String.format("dataSource:[%s] init failed", dataSourceName));
        }
        if (dataSourceAdapter.isValid()) {
            log.info("success to create datasource, dataSourceName = " + dataSourceName);
        }
        return dataSourceAdapter;
    }

    public DataSourceInfo getDataSourceInfo(String dataSourceName) {
        DataSourceInfo dataSourceInfo;
        try {
            dataSourceInfo = MetaHandler.getDataSourceConfigFromDB(dataSourceName);
        }
        catch (Exception e) {
            log.warn(String.format("failed to get dataSourceInfo, name=%s", dataSourceName), (Throwable)e);
            throw new DefinedException(ErrorType.DATA_SOURCE_INIT_FAILED, String.format("dataSource:[%s] init failed", dataSourceName));
        }
        return dataSourceInfo;
    }

    public int getClusterId(String datasourceName) {
        return (int)this.getDataSourceInfo(datasourceName).getClusterId();
    }

    public String getTenantName(String datasourceName) {
        return this.getDataSourceInfo(datasourceName).getTenantName();
    }
}

