/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.helper.TableEntryExtractor;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.datasource.AbstractObDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.calculator.IPartIdCalculator;
import com.oceanbase.tools.migrator.datasource.calculator.OBPartIdCalculator;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySQLModeDataSourceAdapter
extends AbstractObDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObMySQLModeDataSourceAdapter.class);
    private static final int CPU_PERCENT_THRESHOLD = 25;
    private DruidDataSource druidDataSourceByObProxy = null;
    private DataSourceInfo dataSourceInfo;
    private Map<TableEntryKey, TableEntry> tableEntryMap = new ConcurrentHashMap<TableEntryKey, TableEntry>();

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowWrite(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowDelete(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DataSource getDataSource() {
        return this.druidDataSourceByObProxy;
    }

    @Override
    public void closeDataSource() {
        super.closeDataSource();
        if (this.druidDataSourceByObProxy != null) {
            this.druidDataSourceByObProxy.close();
        }
    }

    public ObMySQLModeDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        this.dataSourceInfo = conf;
        log.info(String.format("begin to init datasource OB10: %s", conf.getDataSourceName()));
        if (StringUtils.isEmpty((String)conf.getObProxy()) || conf.getFullUserName() == null || conf.getDatabaseName() == null) {
            log.warn(String.format("missing configure for oceanbase dataSource, conf=%s", conf));
            return;
        }
        this.druidDataSourceByObProxy = this.configDataSourceByObProxy(conf);
        this.obSysDataSourceByObProxy = this.configSysDataSourceByObProxy(conf);
        this.setSleepTime(this.dataSourceInfo.getSleepTime());
        this.initTenantIdInfo(conf, this.getSysConnection());
        this.obVersion = this.getObVersion();
        if (StringUtils.isEmpty((String)this.obVersion)) {
            log.error("Get OB version failed.");
            throw new UnExpectedException("Get OB version failed.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try (Connection connection = this.getSysDataSource().getConnection();){
            this.waitAvailable(connection);
        }
        this.acquire();
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        try (Connection connection = this.getSysDataSource().getConnection();){
            this.waitAvailable(connection);
        }
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnectionForWrite(String sql, Row row) throws SQLException {
        return this.getConnectionForWrite();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        try (Connection connection = this.getSysDataSource().getConnection();){
            this.waitDeleteAvailable(connection);
        }
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getSysConnection() throws SQLException {
        return this.getSysDataSource().getConnection();
    }

    @Override
    public IPartIdCalculator getPartitionIdCalculator(String tableName) throws SQLException {
        return new OBPartIdCalculator(this.getTableEntry(tableName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TableEntry getTableEntry(String tableName) {
        TableEntryKey tableEntryKey = this.getTableEntryKey(tableName);
        if (this.tableEntryMap.containsKey(tableEntryKey)) {
            log.debug("Get table entry from cache,key={}", (Object)tableEntryKey);
            return this.tableEntryMap.get(tableEntryKey);
        }
        try (Connection conn = this.getSysConnection();){
            TableEntryExtractor tableEntryExtractor = new TableEntryExtractor();
            TableEntry tableEntry = tableEntryExtractor.queryTableEntry(conn, tableEntryKey, this.isOB4x());
            this.tableEntryMap.put(tableEntryKey, tableEntry);
            TableEntry tableEntry2 = tableEntry;
            return tableEntry2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Table entry not found,key=%s", tableName), e);
        }
    }

    private TableEntryKey getTableEntryKey(String tableName) {
        return new TableEntryKey(this.getDataSourceInfo().getClusterName(), this.getDataSourceInfo().getTenantName(), this.getDataSourceInfo().getDatabaseName(), tableName, ObServerMode.fromMySql((String)this.getObVersion()));
    }

    public String getObVersion() {
        if (this.obVersion == null) {
            try (Connection conn = this.getConnectionReadOnly();){
                this.obVersion = ObMySQLModeDataSourceAdapter.queryOBVersion(conn);
            }
            catch (SQLException e) {
                log.error("Query ob version failed!", (Throwable)e);
            }
        }
        return this.obVersion;
    }

    @Override
    public Boolean isPartitionTable(String tableName) {
        return this.getTableEntry(tableName).isPartitionTable();
    }

    @Override
    public List<String> getPartitionNames(String tableName) {
        TableEntry tableEntry = this.getTableEntry(tableName);
        ArrayList<String> partitionList = new ArrayList<String>();
        if (tableEntry.isPartitionTable()) {
            Map partitionMap = tableEntry.getTablePart().getPartDesc().getPartNameIdMap();
            ArrayList list = new ArrayList(partitionMap.entrySet());
            list.sort(Map.Entry.comparingByValue());
            partitionList = new ArrayList();
            for (Map.Entry entry : list) {
                partitionList.add((String)entry.getKey());
            }
        }
        return partitionList;
    }

    @Override
    public TableSizeInfo getSourceTableSizeInfo(String tableName) throws SQLException {
        return this.queryTableRowCount(this.getSysConnection(), tableName, this.dataSourceInfo.getDatabaseName(), this.dataSourceInfo.getTenantId());
    }

    private static List<Object> getRowValues(Row row) {
        LinkedList<Object> values = new LinkedList<Object>();
        block4: for (Column column : row.getColumnList()) {
            switch (column.getType()) {
                case NUMBER: {
                    if (column.getString() == null) {
                        values.add(null);
                        continue block4;
                    }
                    BigDecimal bigDecimal = new BigDecimal(column.getString());
                    values.add(bigDecimal);
                    continue block4;
                }
                case BYTES: {
                    byte[] b = (byte[])column.getValue();
                    values.add(b);
                    continue block4;
                }
            }
            values.add(column.getString());
        }
        return values;
    }
}

