/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.framework;

import com.alibaba.fastjson.JSON;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.commons.dbutils.DbUtils;

public class MetaHandler {
    private static final String SELECT_DATASOURCE_CONFIG_SQL = "select cluster_id,dbtype,config,rate_limit from migration_datasources where dbname = ? ;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSourceInfo getDataSourceConfigFromDB(String datasourceName) throws Exception {
        String dbType;
        int rateLimit;
        long clusterId;
        String configString;
        ResultSet rs;
        block27: {
            rs = null;
            configString = null;
            clusterId = -1L;
            rateLimit = -1;
            dbType = "";
            try (Connection connection = MainFramework.getMetaDataSource().getConnectionReadOnly();
                 PreparedStatement ps = connection.prepareStatement(SELECT_DATASOURCE_CONFIG_SQL);){
                ps.setString(1, datasourceName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    clusterId = rs.getLong(1);
                    dbType = rs.getString(2);
                    configString = rs.getString(3);
                    rateLimit = rs.getInt(4);
                    break block27;
                }
                throw new RuntimeException(String.format("Datasource(%s) Not Exist", datasourceName));
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close((ResultSet)rs);
        DataSourceInfo dataSourceInfo = (DataSourceInfo)JSON.parseObject((String)configString, DataSourceInfo.class);
        dataSourceInfo.setDataSourceName(datasourceName);
        dataSourceInfo.setClusterId(clusterId);
        dataSourceInfo.setDbType(dbType);
        dataSourceInfo.setRateLimit(rateLimit);
        dataSourceInfo.setSysUser(MainFramework.getMetaDataSource().getDataSourceInfo().getSysUser());
        dataSourceInfo.setSysPassword(MainFramework.getMetaDataSource().getDataSourceInfo().getSysPassword());
        dataSourceInfo.setSysDatabaseName(MainFramework.getMetaDataSource().getDataSourceInfo().getSysDatabaseName());
        return dataSourceInfo;
    }
}

