/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.framework;

import com.oceanbase.tools.migrator.common.dto.HistoryJob;
import com.oceanbase.tools.migrator.common.enums.JobStatus;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.JobNotFoundException;
import com.oceanbase.tools.migrator.dao.HistoryJobDao;
import com.oceanbase.tools.migrator.dao.MigrationTablesDao;
import com.oceanbase.tools.migrator.framework.MainFramework;
import com.oceanbase.tools.migrator.job.AbstractJob;
import com.oceanbase.tools.migrator.job.JobFactory;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private String jobId;

    public Worker(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public void run() {
        String threadName = String.format("WorkerThread-%s-Main", this.jobId);
        Thread.currentThread().setName(threadName);
        AbstractJob job = null;
        try {
            log.info("Start Run Job {}", (Object)this.jobId);
            job = JobFactory.getJob(this.jobId);
            job.run();
            log.info("Run Job {} Success", (Object)this.jobId);
            this.finishJob(this.jobId);
        }
        catch (InterruptedException e) {
            if (job != null) {
                job.getJobMeta().closeDataAdapter();
                job.getJobMeta().setToStop(true);
            }
            log.info("Job({}) Is Interrupted: ", (Object)this.jobId, (Object)e);
        }
        catch (JobException e) {
            if (job != null) {
                job.getJobMeta().closeDataAdapter();
                job.getJobMeta().setToStop(true);
            }
            log.error("job exception:", (Throwable)e);
            this.updateJobFailed(e);
        }
        catch (RuntimeException e) {
            log.error("unknown exception:", (Throwable)e);
            if (job != null) {
                job.getJobMeta().closeDataAdapter();
                job.getJobMeta().setToStop(true);
            }
            this.updateJobFailed(new JobException(this.jobId, e));
        }
        log.info(threadName + " exit.");
    }

    private void finishJob(String jobId) {
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            connection.setAutoCommit(false);
            HistoryJobDao.updateJobSuccess(connection, jobId);
            HistoryJob historyJob = HistoryJobDao.queryJob(connection, jobId);
            for (String childJobId : historyJob.getChildJobs()) {
                HistoryJobDao.updateJobStatusAndIp(connection, JobStatus.RUNNABLE, null, childJobId);
            }
            switch (historyJob.getJobType()) {
                case MIGRATE: {
                    MigrationTablesDao.updateTableDateMigrated(connection, historyJob.getDateEnd(), historyJob.getTableId());
                    break;
                }
                case DELETE: 
                case QUICK_DELETE: {
                    MigrationTablesDao.updateTableDateDeleted(connection, historyJob.getDateEnd(), historyJob.getTableId());
                    break;
                }
            }
            connection.commit();
        }
        catch (JobNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateJobStatus(JobStatus status, String jobId) {
        log.info("Job({}) Will Be Update To {}.", (Object)jobId, (Object)status);
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            HistoryJobDao.updateJobStatusAndIp(connection, status, MainFramework.getClientIp(), jobId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateJobFailed(JobException jobException) {
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            HistoryJobDao.updateJobFailed(connection, jobException.getErrorType(), jobException.getMessage(), jobException.getJobId());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

