/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.configure;

import com.alibaba.fastjson.annotation.JSONField;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.util.EncryptUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DataSourceInfo {
    @JSONField(ordinal=0)
    private String dbType = null;
    @JSONField(ordinal=3)
    private String rsUrl = null;
    @JSONField(ordinal=3)
    private String jdbcUrl = null;
    @JSONField(ordinal=4)
    private String databaseName = null;
    @JSONField(ordinal=5)
    private String fullUserName = null;
    @JSONField(ordinal=6)
    private String password = null;
    @JSONField(ordinal=7)
    private String connectionProperties = "rewriteBatchedStatements=true;connectTimeout=2000;socketTimeout=60000;GetConnectionTimeout=2000;allowMultiQueries=true;useLocalSessionState=true;yearIsDateType=false;";
    @JSONField(ordinal=8)
    private int connectionCount = 1;
    @JSONField(ordinal=10)
    private int rateLimit = -1;
    @JSONField(ordinal=11)
    private boolean encrypt = false;
    @JSONField(ordinal=15)
    private String ip = "";
    @JSONField(ordinal=16)
    private int port = 3306;
    @JSONField(ordinal=17)
    private int sleepTime = 50;
    @JSONField(ordinal=18)
    private int cpuLimit = 25;
    private long clusterId = -1L;
    private String dataSourceName = null;
    private DataBaseType dataBaseType = DataBaseType.UNKNOWN;
    private String obProxy = null;
    private String sysUser = "";
    private String sysPassword = null;
    private String sysDatabaseName = "";
    private Boolean useLocalProxy = false;
    private Long tenantId = null;
    private String clusterName = null;
    private String tenantName = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getRsUrl() {
        return this.rsUrl;
    }

    public void setRsUrl(String rsUrl) {
        this.rsUrl = rsUrl;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getFullUserName() {
        return this.fullUserName;
    }

    public String getEncryptSysPassword() throws NoSuchPaddingException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        if (this.sysPassword != null) {
            return EncryptUtils.decode(this.sysPassword);
        }
        return null;
    }

    public void setFullUserName(String fullUserName) {
        this.fullUserName = fullUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public void setConnectionCount(int connectionCount) {
        this.connectionCount = connectionCount;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getObProxy() {
        return this.obProxy;
    }

    public void setObProxy(String obProxy) {
        this.obProxy = obProxy;
    }

    public String getSysUser() {
        return this.sysUser;
    }

    public void setSysUser(String sysUser) {
        this.sysUser = sysUser;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword = sysPassword;
    }

    public String getSysDatabaseName() {
        return this.sysDatabaseName;
    }

    public void setSysDatabaseName(String sysDatabaseName) {
        this.sysDatabaseName = sysDatabaseName;
    }

    public void setUserLocalProxy(boolean useLocalProxy) {
        this.useLocalProxy = useLocalProxy;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public int getCpuLimit() {
        return this.cpuLimit;
    }

    public void setCpuLimit(int cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public DataBaseType getDataBaseType() {
        if (this.dbType.equalsIgnoreCase("oceanbaseV10")) {
            this.dataBaseType = DataBaseType.OCEANBASEV10;
        } else if (this.dbType.equalsIgnoreCase("mysql")) {
            this.dataBaseType = DataBaseType.MYSQL;
        } else if (this.dbType.equalsIgnoreCase("oracle")) {
            this.dataBaseType = DataBaseType.ORACLE;
        } else if (this.dbType.equalsIgnoreCase("oceanbase_oracle_mode")) {
            this.dataBaseType = DataBaseType.OCEANBASE_ORACLE_MODE;
        }
        return this.dataBaseType;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getSysFullUserName() {
        if (StringUtils.isEmpty((String)this.fullUserName)) {
            return "";
        }
        return String.format("%s:%s:%s", this.clusterName, "sys", this.sysUser);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dbType", (Object)this.dbType).append("rsUrl", (Object)this.rsUrl).append("databaseName", (Object)this.databaseName).append("fullUserName", (Object)this.fullUserName).append("password", (Object)this.password).append("connectionProperties", (Object)this.connectionProperties).append("ip", (Object)this.ip).append("port", this.port).toString();
    }
}

