/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.configure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.oceanbase.tools.migrator.common.configure.JoinTableInfo;
import com.oceanbase.tools.migrator.common.configure.SubTableInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TableConfig {
    @JSONField(ordinal=1)
    private List<SubTableInfo> subTables = new ArrayList<SubTableInfo>();
    @JSONField(ordinal=2)
    private List<JoinTableInfo> joinTables = new ArrayList<JoinTableInfo>();

    public static TableConfig load(String jsonString, Map<String, String> shardingParameters, String dateStart, String dateEnd) {
        TableConfig tableConfig = (TableConfig)JSON.parseObject((String)jsonString, TableConfig.class);
        if (tableConfig != null) {
            tableConfig.instantiate(shardingParameters, dateStart, dateEnd);
        }
        return tableConfig;
    }

    public void instantiate(Map<String, String> shardingParameters, String dateStart, String dateEnd) {
        if (this.subTables != null) {
            for (SubTableInfo subTableInfo : this.subTables) {
                subTableInfo.instantiate(shardingParameters, dateStart, dateEnd);
            }
        }
        if (this.joinTables != null) {
            for (JoinTableInfo joinTableInfo : this.joinTables) {
                joinTableInfo.instantiate(shardingParameters, dateStart, dateEnd);
            }
        }
    }

    public List<SubTableInfo> getSubTables() {
        return this.subTables;
    }

    public List<JoinTableInfo> getJoinTables() {
        return this.joinTables;
    }

    public void setJoinTables(List<JoinTableInfo> joinTables) {
        this.joinTables = joinTables;
    }

    public void setSubTables(List<SubTableInfo> subTables) {
        this.subTables = subTables;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("subTables", this.subTables).append("JoinTables", this.joinTables).toString();
    }
}

