/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.dto;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.oceanbase.tools.migrator.common.dto.JobParameter;
import com.oceanbase.tools.migrator.common.enums.JobStatus;
import com.oceanbase.tools.migrator.common.enums.JobType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HistoryJob {
    private String id;
    private JobType jobType;
    private JobStatus jobStatus;
    private JobParameter jobParameter = new JobParameter();
    private Long tableId;
    private String sourceDs;
    private String targetDs;
    private Boolean printSqlTrace;
    private String taskGeneratorId;
    private String dateStart;
    private String dateEnd;
    private String sourceTable;
    private String targetTable;
    private Long logicTableId;
    private List<String> childJobs = new ArrayList<String>();
    private Map<String, String> shardingParametersMap;

    public HistoryJob(Map<String, Object> jobEntry) {
        String shardingParameterStr;
        String childJobsStr;
        this.id = (String)jobEntry.get("id");
        this.jobType = JobType.valueOf((String)jobEntry.get("job_type"));
        this.jobStatus = JobStatus.valueOf((String)jobEntry.get("job_status"));
        this.tableId = ((Number)jobEntry.get("table_id")).longValue();
        this.sourceDs = (String)jobEntry.get("source_ds");
        this.targetDs = (String)jobEntry.get("target_ds");
        this.printSqlTrace = (Boolean)jobEntry.get("print_sql_trace");
        this.taskGeneratorId = (String)jobEntry.get("task_generator_id");
        this.dateStart = (String)jobEntry.get("date_start");
        this.dateEnd = (String)jobEntry.get("date_end");
        this.sourceTable = (String)jobEntry.get("source_table_name");
        this.targetTable = (String)jobEntry.get("target_table_name");
        this.logicTableId = ((Number)jobEntry.get("logictable_id")).longValue();
        String jobParameter = (String)jobEntry.get("parameter");
        if (StringUtils.isNotEmpty((String)jobParameter)) {
            this.jobParameter = (JobParameter)JSON.parseObject((String)jobParameter, JobParameter.class);
        }
        if (StringUtils.isNotEmpty((String)(childJobsStr = (String)jobEntry.get("child_jobs")))) {
            this.childJobs = Lists.newArrayList((Object[])StringUtils.split((String)childJobsStr, (char)','));
        }
        if (StringUtils.isNotEmpty((String)(shardingParameterStr = (String)jobEntry.get("sharding_parameter")))) {
            this.shardingParametersMap = (Map)JSON.parseObject((String)shardingParameterStr, Map.class);
        }
    }

    public String getId() {
        return this.id;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public JobParameter getJobParameter() {
        return this.jobParameter;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public String getSourceDs() {
        return this.sourceDs;
    }

    public String getTargetDs() {
        return this.targetDs;
    }

    public Boolean getPrintSqlTrace() {
        return this.printSqlTrace;
    }

    public String getTaskGeneratorId() {
        return this.taskGeneratorId;
    }

    public String getDateStart() {
        return this.dateStart;
    }

    public String getDateEnd() {
        return this.dateEnd;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public Long getLogicTableId() {
        return this.logicTableId;
    }

    public List<String> getChildJobs() {
        return this.childJobs;
    }

    public Map<String, String> getShardingParametersMap() {
        return this.shardingParametersMap;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setJobParameter(JobParameter jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public void setSourceDs(String sourceDs) {
        this.sourceDs = sourceDs;
    }

    public void setTargetDs(String targetDs) {
        this.targetDs = targetDs;
    }

    public void setPrintSqlTrace(Boolean printSqlTrace) {
        this.printSqlTrace = printSqlTrace;
    }

    public void setTaskGeneratorId(String taskGeneratorId) {
        this.taskGeneratorId = taskGeneratorId;
    }

    public void setDateStart(String dateStart) {
        this.dateStart = dateStart;
    }

    public void setDateEnd(String dateEnd) {
        this.dateEnd = dateEnd;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public void setLogicTableId(Long logicTableId) {
        this.logicTableId = logicTableId;
    }

    public void setChildJobs(List<String> childJobs) {
        this.childJobs = childJobs;
    }

    public void setShardingParametersMap(Map<String, String> shardingParametersMap) {
        this.shardingParametersMap = shardingParametersMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryJob)) {
            return false;
        }
        HistoryJob other = (HistoryJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        JobType this$jobType = this.getJobType();
        JobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !((Object)((Object)this$jobType)).equals((Object)other$jobType)) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !((Object)((Object)this$jobStatus)).equals((Object)other$jobStatus)) {
            return false;
        }
        JobParameter this$jobParameter = this.getJobParameter();
        JobParameter other$jobParameter = other.getJobParameter();
        if (this$jobParameter == null ? other$jobParameter != null : !((Object)this$jobParameter).equals(other$jobParameter)) {
            return false;
        }
        Long this$tableId = this.getTableId();
        Long other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
            return false;
        }
        String this$sourceDs = this.getSourceDs();
        String other$sourceDs = other.getSourceDs();
        if (this$sourceDs == null ? other$sourceDs != null : !this$sourceDs.equals(other$sourceDs)) {
            return false;
        }
        String this$targetDs = this.getTargetDs();
        String other$targetDs = other.getTargetDs();
        if (this$targetDs == null ? other$targetDs != null : !this$targetDs.equals(other$targetDs)) {
            return false;
        }
        Boolean this$printSqlTrace = this.getPrintSqlTrace();
        Boolean other$printSqlTrace = other.getPrintSqlTrace();
        if (this$printSqlTrace == null ? other$printSqlTrace != null : !((Object)this$printSqlTrace).equals(other$printSqlTrace)) {
            return false;
        }
        String this$taskGeneratorId = this.getTaskGeneratorId();
        String other$taskGeneratorId = other.getTaskGeneratorId();
        if (this$taskGeneratorId == null ? other$taskGeneratorId != null : !this$taskGeneratorId.equals(other$taskGeneratorId)) {
            return false;
        }
        String this$dateStart = this.getDateStart();
        String other$dateStart = other.getDateStart();
        if (this$dateStart == null ? other$dateStart != null : !this$dateStart.equals(other$dateStart)) {
            return false;
        }
        String this$dateEnd = this.getDateEnd();
        String other$dateEnd = other.getDateEnd();
        if (this$dateEnd == null ? other$dateEnd != null : !this$dateEnd.equals(other$dateEnd)) {
            return false;
        }
        String this$sourceTable = this.getSourceTable();
        String other$sourceTable = other.getSourceTable();
        if (this$sourceTable == null ? other$sourceTable != null : !this$sourceTable.equals(other$sourceTable)) {
            return false;
        }
        String this$targetTable = this.getTargetTable();
        String other$targetTable = other.getTargetTable();
        if (this$targetTable == null ? other$targetTable != null : !this$targetTable.equals(other$targetTable)) {
            return false;
        }
        Long this$logicTableId = this.getLogicTableId();
        Long other$logicTableId = other.getLogicTableId();
        if (this$logicTableId == null ? other$logicTableId != null : !((Object)this$logicTableId).equals(other$logicTableId)) {
            return false;
        }
        List<String> this$childJobs = this.getChildJobs();
        List<String> other$childJobs = other.getChildJobs();
        if (this$childJobs == null ? other$childJobs != null : !((Object)this$childJobs).equals(other$childJobs)) {
            return false;
        }
        Map<String, String> this$shardingParametersMap = this.getShardingParametersMap();
        Map<String, String> other$shardingParametersMap = other.getShardingParametersMap();
        return !(this$shardingParametersMap == null ? other$shardingParametersMap != null : !((Object)this$shardingParametersMap).equals(other$shardingParametersMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        JobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : ((Object)((Object)$jobType)).hashCode());
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : ((Object)((Object)$jobStatus)).hashCode());
        JobParameter $jobParameter = this.getJobParameter();
        result = result * 59 + ($jobParameter == null ? 43 : ((Object)$jobParameter).hashCode());
        Long $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        String $sourceDs = this.getSourceDs();
        result = result * 59 + ($sourceDs == null ? 43 : $sourceDs.hashCode());
        String $targetDs = this.getTargetDs();
        result = result * 59 + ($targetDs == null ? 43 : $targetDs.hashCode());
        Boolean $printSqlTrace = this.getPrintSqlTrace();
        result = result * 59 + ($printSqlTrace == null ? 43 : ((Object)$printSqlTrace).hashCode());
        String $taskGeneratorId = this.getTaskGeneratorId();
        result = result * 59 + ($taskGeneratorId == null ? 43 : $taskGeneratorId.hashCode());
        String $dateStart = this.getDateStart();
        result = result * 59 + ($dateStart == null ? 43 : $dateStart.hashCode());
        String $dateEnd = this.getDateEnd();
        result = result * 59 + ($dateEnd == null ? 43 : $dateEnd.hashCode());
        String $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : $sourceTable.hashCode());
        String $targetTable = this.getTargetTable();
        result = result * 59 + ($targetTable == null ? 43 : $targetTable.hashCode());
        Long $logicTableId = this.getLogicTableId();
        result = result * 59 + ($logicTableId == null ? 43 : ((Object)$logicTableId).hashCode());
        List<String> $childJobs = this.getChildJobs();
        result = result * 59 + ($childJobs == null ? 43 : ((Object)$childJobs).hashCode());
        Map<String, String> $shardingParametersMap = this.getShardingParametersMap();
        result = result * 59 + ($shardingParametersMap == null ? 43 : ((Object)$shardingParametersMap).hashCode());
        return result;
    }

    public String toString() {
        return "HistoryJob(id=" + this.getId() + ", jobType=" + (Object)((Object)this.getJobType()) + ", jobStatus=" + (Object)((Object)this.getJobStatus()) + ", jobParameter=" + this.getJobParameter() + ", tableId=" + this.getTableId() + ", sourceDs=" + this.getSourceDs() + ", targetDs=" + this.getTargetDs() + ", printSqlTrace=" + this.getPrintSqlTrace() + ", taskGeneratorId=" + this.getTaskGeneratorId() + ", dateStart=" + this.getDateStart() + ", dateEnd=" + this.getDateEnd() + ", sourceTable=" + this.getSourceTable() + ", targetTable=" + this.getTargetTable() + ", logicTableId=" + this.getLogicTableId() + ", childJobs=" + this.getChildJobs() + ", shardingParametersMap=" + this.getShardingParametersMap() + ")";
    }

    public HistoryJob() {
    }
}

