/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.element;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import java.util.Arrays;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BytesColumn
extends Column {
    private byte[] value = null;

    public BytesColumn(DataType type, byte[] value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public long getByteSize() {
        return this.value == null ? 1L : (long)this.value.length;
    }

    @Override
    public String getString() {
        if (this.value == null) {
            return null;
        }
        String s = new String(this.value);
        return s;
    }

    @Override
    public Long getLong() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesColumn that = (BytesColumn)o;
        return this.value != null ? Arrays.equals(this.value, that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean isMatch(Column c) {
        if (c.type != this.type) {
            return false;
        }
        BytesColumn that = (BytesColumn)c;
        return this.value != null ? Arrays.equals(this.value, that.value) : that.value == null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("columnType", (Object)this.type).append("value", this.value).toString();
    }
}

