/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final String PARAM_PATTERN = "\\$\\{.*?\\}";

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            log.warn("failed to generate md5, input = " + input, (Throwable)e);
            return null;
        }
    }

    public static String replaceDateEnd(String input, String dateEnd) {
        return CommonUtils.replaceDate(input, "${date_end}", dateEnd);
    }

    public static String replaceDateStart(String input, String dateStart) {
        return CommonUtils.replaceDate(input, "${date_start}", dateStart);
    }

    public static String replaceDate(String input, String pattern, String date) {
        return input.replace(pattern, date);
    }

    public static String instantiateStringWithParam(String pattern, Map<String, String> parameterMap) {
        Pattern keyPattern = Pattern.compile(PARAM_PATTERN);
        Matcher keyMatcher = keyPattern.matcher(pattern);
        StringBuffer stringBuffer = new StringBuffer();
        while (keyMatcher.find()) {
            String key = keyMatcher.group();
            keyMatcher.appendReplacement(stringBuffer, parameterMap.get(key.substring(2, key.length() - 1)));
        }
        keyMatcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

