/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.util;

import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.RepairType;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRepairUtils {
    private static final Logger log = LoggerFactory.getLogger(SchemaRepairUtils.class);

    public static List<String> generateColumnRepairSqlScript(TableMeta sourceTableMeta, TableMeta targetTableMeta, DataBaseType dbType) {
        LinkedList<String> repairSqls = new LinkedList<String>();
        List<ColumnMeta> sourceColumnMetas = sourceTableMeta.getColumnMetas();
        List<ColumnMeta> targetColumnMetas = targetTableMeta.getColumnMetas();
        LinkedList<ColumnMeta> columnToAdd = new LinkedList<ColumnMeta>();
        LinkedList<ColumnMeta> columnToExpand = new LinkedList<ColumnMeta>();
        for (ColumnMeta sourceColumn : sourceColumnMetas) {
            boolean isColumnExistOnTarget = false;
            boolean isColumnLengthNotMatch = false;
            for (ColumnMeta targetColumn : targetColumnMetas) {
                if (!sourceColumn.getName().equalsIgnoreCase(targetColumn.getName())) continue;
                isColumnExistOnTarget = true;
                if (sourceColumn.getType() != DataType.STRING || sourceColumn.getDataLength() == null || targetColumn.getDataLength() == null || sourceColumn.getDataLength() <= targetColumn.getDataLength()) break;
                isColumnLengthNotMatch = true;
                break;
            }
            if (!isColumnExistOnTarget) {
                columnToAdd.add(sourceColumn);
            }
            if (!isColumnLengthNotMatch) continue;
            columnToExpand.add(sourceColumn);
        }
        AbstractSqlBuilder abstractSqlBuilder = SqlBuilderFactory.getSqlBuilder(dbType);
        for (ColumnMeta column : columnToAdd) {
            repairSqls.add(abstractSqlBuilder.generateColumnRepairSql(column, targetTableMeta.getName(), RepairType.ADD_COLUMN));
        }
        for (ColumnMeta column : columnToExpand) {
            repairSqls.add(abstractSqlBuilder.generateColumnRepairSql(column, targetTableMeta.getName(), RepairType.EXPAND_COLUMN));
        }
        return repairSqls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeRepairSql(List<String> repairSqls, DataSourceAdapter dataSourceAdapter) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSourceAdapter.getConnectionReadOnly();
            for (String sql : repairSqls) {
                log.info("execute Sql: {}", (Object)sql);
                statement = connection.createStatement();
                statement.executeUpdate(sql);
            }
        }
        finally {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly(connection);
        }
    }
}

