/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core;

import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.dto.HistoryJob;
import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.PrimaryKeyChoice;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.TableMetaInitException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.meta.TableMetaManager;
import com.oceanbase.tools.migrator.common.util.ResourceIdUtils;
import com.oceanbase.tools.migrator.core.IJobStore;
import com.oceanbase.tools.migrator.core.JobReq;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.handler.genarator.GeneratorType;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.DataSourceFactory;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobMetaFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractJobMetaFactory.class);
    private IJobStore jobStore;
    private ExecutorService executorService = null;
    private Thread monitor;

    public JobMeta create(JobReq jobReq) throws Exception {
        try {
            HistoryJob historyJob = jobReq.getHistoryJob();
            JobMeta jobMeta = new JobMeta();
            jobMeta.setJobId(historyJob.getId());
            jobMeta.setJobType(historyJob.getJobType());
            jobMeta.setJobStatus(historyJob.getJobStatus());
            jobMeta.setNeedPrintSqlTrace(historyJob.getPrintSqlTrace());
            jobMeta.setDateStart(historyJob.getDateStart());
            jobMeta.setDateEnd(historyJob.getDateEnd());
            jobMeta.setJobParameter(historyJob.getJobParameter());
            jobMeta.setLogicTableConfig(jobReq.getLogicTableConfig());
            jobMeta.setTargetCluster(jobReq.getTargetCluster());
            jobMeta.setSourceCluster(jobReq.getSourceCluster());
            jobMeta.setSourceTenant(jobReq.getSourceTenant());
            jobMeta.setTargetTenant(jobReq.getTargetTenant());
            jobMeta.setSourceAdapter(DataSourceFactory.getDataSource(jobReq.getSourceDs()));
            jobMeta.setTargetAdapter(DataSourceFactory.getDataSource(jobReq.getTargetDs()));
            TaskGenerator generator = this.jobStore.getTaskGenerator(historyJob.getTaskGeneratorId(), historyJob.getId());
            if (generator == null) {
                generator = new TaskGenerator();
                generator.setId(ResourceIdUtils.getResourceId("g"));
                generator.setJobId(historyJob.getId());
                generator.setGeneratorType(GeneratorType.AUTO);
                this.jobStore.storeTaskGenerator(generator);
                this.jobStore.bindGeneratorToJob(historyJob.getId(), generator);
            }
            jobMeta.setGenerator(generator);
            this.initTableMeta(jobMeta, historyJob.getSourceTable(), historyJob.getTargetTable(), historyJob.getTableId());
            if (this.useTargetTableMetaAsPrimary(jobMeta)) {
                log.info("source table has a index for target table primary key, set primaryTableMeta use targetTableMeta");
                jobMeta.setPrimaryTableMeta(jobMeta.getTargetTableMeta());
            } else {
                log.info("set primary table meta use source table meta");
                jobMeta.setPrimaryTableMeta(jobMeta.getSourceTableMeta());
            }
            jobMeta.getJobStat().setRowCount(generator.getProcessedRowCount());
            jobMeta.getJobStat().setDataSize(generator.getProcessedDataSize());
            if (this.needDateCondition(jobMeta)) {
                this.genDateConditionExpr(jobMeta);
            }
            jobMeta.setJobService(this.jobStore);
            jobMeta.setExecutorService(this.executorService);
            jobMeta.updateLimitAndStatus();
            return jobMeta;
        }
        catch (Exception e) {
            log.warn("Create job meta failed,error=", (Throwable)e);
            throw e;
        }
    }

    private boolean useTargetTableMetaAsPrimary(final JobMeta jobMeta) throws SQLException {
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        final DataSourceAdapter sourceAdapter = jobMeta.getSourceAdapter();
        final TableMeta targetTableMeta = jobMeta.getTargetTableMeta();
        final TableMeta sourceTableMeta = jobMeta.getSourceTableMeta();
        final DataSourceAdapter targetAdapter = jobMeta.getTargetAdapter();
        boolean ret = false;
        if (logicTableConfig != null && !sourceTableMeta.hasSamePk(targetTableMeta)) {
            if (logicTableConfig.getPrimaryKeyChoice() != null) {
                return logicTableConfig.getPrimaryKeyChoice() == PrimaryKeyChoice.USE_TARGET_PRIMARY;
            }
            ret = (Boolean)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(sourceAdapter){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run(Connection connection) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        return ret;
    }

    private void genDateConditionExpr(JobMeta jobMeta) throws DefinedException {
        String expr;
        switch (jobMeta.getSourceAdapter().getDataBaseType()) {
            case OCEANBASEV10: 
            case MYSQL: 
            case OCEANBASE_ORACLE_MODE: 
            case OCEANBASE_REMOTE_PROXY: {
                expr = this.genObDateConditionExpr(jobMeta);
                break;
            }
            case ORACLE: {
                expr = this.getOracleDateConditionExpr(jobMeta);
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this datasource type: " + jobMeta.getSourceAdapter().getDataBaseType().name());
            }
        }
        jobMeta.setDateConditionExpr(expr);
    }

    private String genObDateConditionExpr(JobMeta jobMeta) throws DefinedException {
        String expr = null;
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        if (logicTableConfig.getMigrateDateFormat() != null && logicTableConfig.getMigrateDateColumn() != null) {
            expr = String.format("%s >= '%s' AND %s < '%s'", logicTableConfig.getMigrateDateColumn(), SqlUtils.formatDateString(jobMeta.getDateStart(), logicTableConfig.getMigrateDateFormat()), logicTableConfig.getMigrateDateColumn(), SqlUtils.formatDateString(jobMeta.getDateEnd(), logicTableConfig.getMigrateDateFormat()));
        }
        return expr;
    }

    private String getOracleDateConditionExpr(JobMeta jobMeta) {
        String expr = null;
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        if (logicTableConfig.getMigrateDateFormat() != null && logicTableConfig.getMigrateDateColumn() != null) {
            DataType dataType = DataType.UNKNOWN;
            if (jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn()) != null) {
                dataType = jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn()).getType();
            } else if (jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn().toUpperCase()) != null) {
                dataType = jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn().toUpperCase()).getType();
            }
            if (!dataType.equals((Object)DataType.UNKNOWN)) {
                expr = String.format("%s >= %s AND %s < %s", logicTableConfig.getMigrateDateColumn().toUpperCase(), SqlUtils.formatOracleDateString(jobMeta.getDateStart(), logicTableConfig.getMigrateDateFormat(), dataType), logicTableConfig.getMigrateDateColumn().toUpperCase(), SqlUtils.formatOracleDateString(jobMeta.getDateEnd(), logicTableConfig.getMigrateDateFormat(), dataType));
            } else {
                throw new DefinedException(ErrorType.UNEXPECTED_ERROR, String.format("not find date column: [%s]", logicTableConfig.getMigrateDateColumn()));
            }
        }
        return expr;
    }

    private boolean needDateCondition(JobMeta jobMeta) {
        if (jobMeta.getLogicTableConfig().getMigrateDateColumn() != null && jobMeta.getLogicTableConfig().getMigrateDateFormat() != null) {
            return !AbstractJobMetaFactory.isDateColumnPkColumnPrefix(jobMeta);
        }
        return false;
    }

    public void initTableMeta(JobMeta jobMeta, String srcTable, String targetTable, Long tableId) throws TableMetaInitException {
        try {
            jobMeta.setSourceTableMeta(TableMetaManager.getTableMeta(jobMeta.getSourceAdapter(), srcTable, tableId));
            jobMeta.setTargetTableMeta(TableMetaManager.getTableMeta(jobMeta.getTargetAdapter(), targetTable, tableId));
        }
        catch (SQLException e) {
            throw new TableMetaInitException(jobMeta.getJobId(), e);
        }
    }

    public static boolean isDateColumnPkColumnPrefix(JobMeta jobMeta) {
        return jobMeta.getPrimaryTableMeta().getPkColIdx(jobMeta.getLogicTableConfig().getMigrateDateColumn()) == 0;
    }

    public void setJobStore(IJobStore jobStore) {
        this.jobStore = jobStore;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.initMonitor();
    }

    private void initMonitor() {
        this.monitor = new Thread(() -> {
            ThreadPoolExecutor target = (ThreadPoolExecutor)this.executorService;
            while (true) {
                log.info("Active:[{}],CorePoolSize:[{}]", (Object)target.getActiveCount(), (Object)target.getCorePoolSize());
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.info("Dlm task thread pool monitor has been interrupted.");
                    continue;
                }
                break;
            }
        });
        this.monitor.setDaemon(true);
        this.monitor.setName("DLM-SubTaskThreadPool-Monitor");
        this.monitor.start();
        log.info("Init thread monitor succeed.");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

