/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core;

import com.oceanbase.tools.migrator.common.dto.JobStatistic;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.JobSqlException;
import com.oceanbase.tools.migrator.common.exception.JobStatisticNotFoundException;
import com.oceanbase.tools.migrator.common.exception.TaskGeneratorNotFoundException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.IJobStore;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.AbstractWriteHandler;
import com.oceanbase.tools.migrator.core.handler.ClusterMetaHandle;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.handler.TenantMetaHandle;
import com.oceanbase.tools.migrator.core.meta.ClusterMeta;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.core.meta.TenantMeta;
import com.oceanbase.tools.migrator.dao.HistoryJobDao;
import com.oceanbase.tools.migrator.dao.HistoryJobStatisticDao;
import com.oceanbase.tools.migrator.dao.HistoryTaskGeneratorDao;
import com.oceanbase.tools.migrator.dao.MigrationTablesDao;
import com.oceanbase.tools.migrator.dao.TaskDao;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobStore
implements IJobStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultJobStore.class);

    @Override
    public TaskGenerator getTaskGenerator(String generatorId, String jobId) throws TaskGeneratorNotFoundException, SQLException {
        return HistoryTaskGeneratorDao.queryTaskGenerator(MainFramework.getMetaDataSource().getConnection(), generatorId, jobId);
    }

    @Override
    public void storeTaskGenerator(TaskGenerator taskGenerator) throws SQLException {
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            connection.setAutoCommit(false);
            HistoryTaskGeneratorDao.saveTaskGenerator(connection, taskGenerator);
            connection.commit();
        }
    }

    @Override
    public void bindGeneratorToJob(String jobId, TaskGenerator generator) throws SQLException {
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            connection.setAutoCommit(false);
            HistoryJobDao.updateJobGenerator(connection, generator.getId(), jobId);
            connection.commit();
        }
    }

    @Override
    public JobStatistic getJobStatistic(String jobId) throws JobException {
        JobStatistic jobStatistic;
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            jobStatistic = HistoryJobStatisticDao.queryJobStatistic(connection, jobId);
        }
        catch (SQLException e) {
            throw new JobException(jobId, e.getMessage());
        }
        catch (JobStatisticNotFoundException e) {
            jobStatistic = new JobStatistic();
        }
        return jobStatistic;
    }

    @Override
    public void storeJobStatistic(JobMeta jobMeta) throws JobSqlException {
        jobMeta.getJobStat().buildReportData();
        try {
            final JobStatistic jobStatistic = new JobStatistic(jobMeta.getJobId(), jobMeta.getJobStat());
            jobStatistic.setCpuLimit(jobMeta.getSourceAdapter().getCpuLimitDsName() + jobMeta.getTargetAdapter().getCpuLimitDsName());
            jobStatistic.setMemLimit(jobMeta.getSourceAdapter().getMemLimitDsName() + jobMeta.getTargetAdapter().getMemLimitDsName());
            HandlerUtils.runWithRetry(new AbstractWriteHandler(MainFramework.getMetaDataSource()){

                @Override
                public Object run(Connection connection) throws SQLException {
                    try {
                        connection.setAutoCommit(false);
                        HistoryJobStatisticDao.saveJobStatistic(connection, jobStatistic);
                        connection.commit();
                        Object var2_2 = null;
                        return var2_2;
                    }
                    finally {
                        connection.setAutoCommit(true);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new JobSqlException(jobMeta.getJobId(), e);
        }
    }

    @Override
    public List<TaskMeta> getTaskMeta(final JobMeta jobMeta) throws SQLException {
        Object o = HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(MainFramework.getTaskDataSource()){

            @Override
            public Object run(Connection connection) throws SQLException {
                return TaskDao.batchQueryTasks(connection, jobMeta);
            }
        });
        return o == null ? null : (List)o;
    }

    @Override
    public void storeTaskMeta(final TaskMeta taskMeta) throws SQLException {
        HandlerUtils.runWithSimpleRetry(new AbstractWriteHandler(MainFramework.getTaskDataSource()){

            @Override
            public Object run(Connection connection) throws SQLException {
                TaskDao.saveTask(connection, taskMeta);
                return null;
            }
        });
    }

    @Override
    public Long getAbnormalTaskIndex(final String jobId) throws JobSqlException {
        try {
            return (Long)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(MainFramework.getTaskDataSource()){

                @Override
                public Object run(Connection connection) throws SQLException {
                    return TaskDao.queryAbnormalTaskIndex(connection, jobId);
                }
            });
        }
        catch (SQLException e) {
            throw new JobSqlException(jobId, e);
        }
    }

    @Override
    public void updateTableSizeInfo(final TableSizeInfo tableSizeInfo, final long tableId) {
        try {
            HandlerUtils.runWithoutRetry(new AbstractReadHandler(MainFramework.getMetaDataSource()){

                @Override
                public Object run(Connection connection) throws SQLException {
                    MigrationTablesDao.updateTableSizeInfo(connection, tableSizeInfo, tableId);
                    return null;
                }
            });
        }
        catch (SQLException e) {
            log.warn(String.format("Update Table RowCount Failed, tableId:%s", tableId), (Throwable)e);
        }
    }

    @Override
    public void updateLimiter(JobMeta jobMeta) throws SQLException {
        this.updateClusterLimit(jobMeta.getSourceCluster());
        this.updateClusterLimit(jobMeta.getTargetCluster());
        this.updateTenantLimit(jobMeta.getSourceTenant());
        this.updateTenantLimit(jobMeta.getTargetTenant());
        this.updateTableLimit(jobMeta.getSourceTableMeta());
        this.updateTableLimit(jobMeta.getTargetTableMeta());
    }

    private void updateClusterLimit(ClusterMeta clusterMeta) throws SQLException {
        ClusterMeta load = ClusterMetaHandle.getClusterMeta(clusterMeta.getClusterId());
        clusterMeta.setReadUsedQuota(load.getReadUsedQuota());
        clusterMeta.setWriteUsedQuota(load.getWriteUsedQuota());
        long newReadSizeLimit = load.getReadSizeLimit();
        long newWriteSizeLimit = load.getWriteSizeLimit();
        if (clusterMeta.getReadSizeLimit() != newReadSizeLimit) {
            log.info(String.format("cluster %s change read size limit from %d to %d", clusterMeta.getClusterName(), clusterMeta.getReadSizeLimit(), newReadSizeLimit));
            clusterMeta.setReadSizeLimit(newReadSizeLimit);
        }
        if (clusterMeta.getWriteSizeLimit() != newWriteSizeLimit) {
            log.info(String.format("cluster %s change write size limit from %d to %d", clusterMeta.getClusterName(), clusterMeta.getWriteSizeLimit(), newWriteSizeLimit));
            clusterMeta.setWriteSizeLimit(newWriteSizeLimit);
        }
    }

    private void updateTenantLimit(TenantMeta tenantMeta) throws SQLException {
        TenantMeta load = TenantMetaHandle.getTenantMeta(tenantMeta.getTenantName());
        tenantMeta.setReadUsedQuota(load.getReadUsedQuota());
        tenantMeta.setWriteUsedQuota(load.getWriteUsedQuota());
        long newReadSizeLimit = load.getReadSizeLimit();
        long newWriteSizeLimit = load.getWriteSizeLimit();
        boolean newIsLimit = load.isLimit();
        if (tenantMeta.getReadSizeLimit() != newReadSizeLimit) {
            log.info(String.format("tenant %s change read size limit from %d to %d", tenantMeta.getTenantName(), tenantMeta.getReadSizeLimit(), newReadSizeLimit));
            tenantMeta.setReadSizeLimit(newReadSizeLimit);
        }
        if (tenantMeta.getWriteSizeLimit() != newWriteSizeLimit) {
            log.info(String.format("tenant %s change write size limit from %d to %d", tenantMeta.getTenantName(), tenantMeta.getWriteSizeLimit(), newWriteSizeLimit));
            tenantMeta.setWriteSizeLimit(newWriteSizeLimit);
        }
        if (newIsLimit != tenantMeta.isLimit()) {
            log.info(String.format("tenant %s change isLimit to %s", tenantMeta.isLimit(), newIsLimit));
            tenantMeta.setLimit(newIsLimit);
        }
    }

    private void updateTableLimit(TableMeta tableMeta) throws SQLException {
    }
}

