/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.RepairType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMysqlSqlBuilder
extends AbstractSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ObMysqlSqlBuilder.class);
    private static Pattern EXTRACT_NUMBER = Pattern.compile("(?<=\\()[^)]+");
    private static Pattern EXTRACT_VARCHAR = Pattern.compile("varchar\\((?<length>\\w+)\\)");
    private static Pattern PK_PATTERN = Pattern.compile("PRIMARY KEY \\(.*?\\)");

    protected String format() {
        this.hint = "/*+ READ_CLUSTER(SLAVE), READ_CONSISTENCY(WEAK), NO_REWRITE, QUERY_TIMEOUT(30000000) */";
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.getHint());
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.getTableName()).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" ").append("WHERE");
        }
        int conditionCount = 0;
        for (String userDefinedCondition : this.userDefinedConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(userDefinedCondition).append(")");
            ++conditionCount;
        }
        for (String primaryKeyCondition : this.primaryKeyConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(primaryKeyCondition).append(")");
            ++conditionCount;
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.getOffset()).append(" ,");
            }
            builder.append(" ").append(this.getLimit());
        }
        return builder.toString();
    }

    @Override
    public String getIndexSql(String tableName) {
        return String.format("show index from %s", tableName);
    }

    @Override
    public String getDescSql(String tableName, String tableOwner) {
        return String.format("desc `%s`", tableName);
    }

    @Override
    public String getReadDataSql() {
        return this.format();
    }

    @Override
    public String getSplitSql() {
        return this.format();
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                sqlStr = String.format("'%s'", column.getString());
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    private String appendEscapeChar(String stringValue) {
        StringBuilder buffer = new StringBuilder((int)((double)stringValue.length() * 1.1));
        buffer.append("'");
        block8: for (char c : stringValue.toCharArray()) {
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block8;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("'");
        return buffer.toString();
    }

    private boolean isEscapeNeededForString(Column column) {
        boolean needsHexEscape = false;
        for (char c : column.getString().toCharArray()) {
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolvePkColumn(Connection connection, String tableName, List<ColumnMeta> columnMetas, String tableOwner) {
        block10: {
            String tableDefinitionColumn = "Create Table";
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                String sql = String.format("show create table `%s`", tableName);
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String tableDefinition = "";
                    tableDefinition = rs.getString(tableDefinitionColumn);
                    Pattern pattern = PK_PATTERN;
                    Matcher matcher = pattern.matcher(tableDefinition);
                    String pkColListStr = null;
                    if (matcher.find()) {
                        pkColListStr = matcher.group();
                    }
                    if (pkColListStr == null) {
                        log.warn(String.format("pkColListStr is null, %s, %s", tableDefinition, pkColListStr));
                        throw new UnExpectedException("unexpected");
                    }
                    pattern = EXTRACT_NUMBER;
                    if (!(matcher = pattern.matcher(matcher.group())).find()) continue;
                    String[] pkCols = matcher.group().replaceAll("`", "").split(",");
                    log.debug(String.format("table_name: %s, pk_cols_name%s", tableName, pkCols));
                    block6: for (int i = 0; i < pkCols.length; ++i) {
                        for (ColumnMeta columnMeta : columnMetas) {
                            if (columnMeta.getName().compareToIgnoreCase(pkCols[i].trim()) != 0) continue;
                            columnMeta.setPkColIdx(i);
                            continue block6;
                        }
                    }
                }
                DbUtils.closeQuietly(rs);
            }
            catch (SQLException e) {
                log.warn("fail to resolve Oceanbase/MySQL PK column", (Throwable)e);
                break block10;
            }
            finally {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(statement);
            }
            DbUtils.closeQuietly(statement);
        }
    }

    @Override
    public List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String extraColumn = "Extra";
        String defaultColumn = "Default";
        String nullableColumn = "Null";
        String fieldColumn = "Field";
        String typeColumn = "Type";
        Pattern VIRTUAL_GENERATED = Pattern.compile("VIRTUAL GENERATED");
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            Matcher varcharMatcher;
            Matcher matcher;
            DataType dataType;
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setName(rs.getString(fieldColumn));
            columnMeta.setColumnType(rs.getString(typeColumn));
            columnMeta.setNullAble("YES".equals(rs.getString(nullableColumn).toUpperCase()));
            columnMeta.setExtra(rs.getString(extraColumn));
            columnMeta.setDefaultValue("NULL".equals(rs.getString(defaultColumn)) ? null : rs.getString(defaultColumn));
            Pattern virtualGenPattern = VIRTUAL_GENERATED;
            Matcher virtualGenMatcher = virtualGenPattern.matcher(columnMeta.getExtra());
            if (virtualGenMatcher.find()) continue;
            String typeLower = columnMeta.getColumnType().toLowerCase();
            if (typeLower.contains("int")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("char")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("varchar")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("text")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("numeric")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("decimal")) {
                dataType = DataType.DECIMAL;
            } else if (typeLower.contains("date") || typeLower.contains("year")) {
                dataType = DataType.DATE;
            } else if (typeLower.contains("time")) {
                dataType = DataType.TIME;
            } else if (typeLower.contains("datetime")) {
                dataType = DataType.DATETIME;
            } else if (typeLower.contains("timestamp")) {
                dataType = DataType.TIMESTAMP;
            } else if (typeLower.contains("binary") || typeLower.contains("blob")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("double")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("float")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("json")) {
                dataType = DataType.JSON;
            } else {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type: " + typeLower);
            }
            columnMeta.setType(dataType);
            if ((dataType == DataType.NUMBER || dataType == DataType.DECIMAL || dataType == DataType.DOUBLE) && (matcher = EXTRACT_NUMBER.matcher(columnMeta.getColumnType())).find()) {
                if (matcher.group().contains(",")) {
                    String[] nums = matcher.group().split(",");
                    columnMeta.setPrecision(Integer.valueOf(nums[0]));
                    columnMeta.setScope(Integer.valueOf(nums[1]));
                } else {
                    columnMeta.setPrecision(Integer.valueOf(matcher.group()));
                    columnMeta.setScope(0);
                }
            }
            if (dataType == DataType.STRING && (varcharMatcher = EXTRACT_VARCHAR.matcher(columnMeta.getColumnType())).matches()) {
                int dataLength = Integer.valueOf(varcharMatcher.group("length"));
                columnMeta.setDataLength(dataLength);
            }
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }

    @Override
    public String generateColumnRepairSql(ColumnMeta column, String tableName, RepairType repairType) {
        StringBuilder repairSql = new StringBuilder();
        repairSql.append("ALTER TABLE ");
        repairSql.append("`").append(tableName).append("`");
        if (repairType == RepairType.ADD_COLUMN) {
            repairSql.append(" ADD COLUMN ");
        } else {
            repairSql.append(" MODIFY COLUMN ");
        }
        repairSql.append("`").append(column.getName()).append("`");
        repairSql.append(" ").append(column.getColumnType()).append(" ");
        if (column.getNullAble().booleanValue()) {
            repairSql.append(" NULL ");
        } else {
            repairSql.append(" NOT NULL ");
        }
        if (StringUtils.isNotEmpty((String)column.getDefaultValue())) {
            repairSql.append(" DEFAULT ");
            if (column.getType() == DataType.STRING) {
                repairSql.append("'").append(column.getDefaultValue()).append("'");
            } else {
                repairSql.append(column.getDefaultValue());
            }
        }
        repairSql.append(" ");
        repairSql.append(column.getExtra());
        return repairSql.toString();
    }
}

