/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.data;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRows
extends AbstractData {
    private static final Logger log = LoggerFactory.getLogger(BatchRows.class);
    protected TableMeta tableMeta = null;
    private List<Row> rows = null;
    private TransRows ownerTransRows = null;
    private int scanRowCount = 0;
    private long dataSize = 0L;

    public BatchRows() {
        this(200);
    }

    public BatchRows(int batchSize) {
        this.rows = new ArrayList<Row>(batchSize);
    }

    public void addRow(Row row) {
        row.setOwnerBatchRows(this);
        this.dataSize += row.getDataSize();
        this.rows.add(row);
    }

    public void setScanRowCount(int scanRowCount) {
        this.scanRowCount = scanRowCount;
    }

    public int getReadRowCount() {
        return this.scanRowCount > this.rows.size() ? this.scanRowCount : this.rows.size();
    }

    @Override
    public AbstractData getOwner() {
        return this.ownerTransRows;
    }

    public void setOwnerTransRows(TransRows ownerTransRows) {
        this.ownerTransRows = ownerTransRows;
    }

    public TransRows getOwnerTransRows() {
        return this.ownerTransRows;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void setTableMeta(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public PrimaryKey getMinPrimaryKey() {
        if (this.rows.size() < 1) {
            throw new UnExpectedException("row count should not be null here");
        }
        return this.rows.get(0).getPrimaryKey();
    }

    public PrimaryKey getMaxPrimaryKey() {
        if (this.rows.size() < 1) {
            throw new UnExpectedException("row count should not be null here");
        }
        return this.rows.get(this.rows.size() - 1).getPrimaryKey();
    }

    public boolean isMatch(BatchRows targetBatchRows) {
        List<Row> srcRows = this.rows;
        List<Row> targetRows = targetBatchRows.rows;
        if (srcRows.size() > targetRows.size()) {
            String errMsg = String.format("table name = %s, srcMinKey = %s, srcMaxKey = %s, srcCount = %d, targetCount = %d", this.tableMeta.getName(), this.getMinPrimaryKey().toSqlString(), this.getMaxPrimaryKey().toSqlString(), srcRows.size(), targetRows.size());
            this.setError(ErrorType.CHECK_RECORD_COUNT_NOT_MATCH, errMsg);
            log.error("check batch row counts are not matched, " + errMsg);
            this.ownerTransRows.setHasDirty(true);
            return false;
        }
        if (srcRows.size() < targetRows.size()) {
            int srcIndex = 0;
            int targetIndex = 0;
            while (srcIndex < srcRows.size() && targetIndex < targetRows.size()) {
                if (srcRows.get(srcIndex).equals(targetRows.get(targetIndex))) {
                    ++srcIndex;
                    ++targetIndex;
                    continue;
                }
                ++targetIndex;
            }
            if (srcIndex != srcRows.size()) {
                String errMsg = String.format("table name = %s, srcMinKey = %s, srcMaxKey = %s, srcCount = %d, targetCount = %d, some rows are not exist in target", this.tableMeta.getName(), this.getMinPrimaryKey().toSqlString(), this.getMaxPrimaryKey().toSqlString(), srcRows.size(), targetRows.size());
                this.setError(ErrorType.CHECK_ROW_NOT_EXISTS_IN_TARGET, errMsg);
                log.error("check batch row counts are not matched, " + errMsg);
                return false;
            }
        } else {
            for (int i = 0; i < srcRows.size(); ++i) {
                if (srcRows.get(i).isMatch(targetRows.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Row getRow(int idx) {
        return this.rows.get(idx);
    }

    public void resetDirtyRows() {
        for (Row row : this.rows) {
            row.resetDirtyRow();
        }
    }

    public Boolean hasDirtyBatchRow() {
        boolean hasDirty = false;
        for (Row row : this.rows) {
            if (!row.isDirtyRow()) continue;
            hasDirty = true;
            break;
        }
        return hasDirty;
    }
}

