/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.data;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.tools.migrator.common.element.BytesColumn;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.core.data.Row;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowUtils {
    public static Row getRow(ResultSet rs, DataBaseType dbType) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        Row row = new Row(metaData.getColumnCount());
        block12: for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            switch (metaData.getColumnType(i)) {
                case -1: 
                case 1: 
                case 12: {
                    String rawData = rs.getString(i);
                    row.addColumn(new StringColumn(DataType.STRING, rawData));
                    continue block12;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    String l = rs.getString(i);
                    if (rs.wasNull()) {
                        l = null;
                    }
                    row.addColumn(new StringColumn(DataType.NUMBER, l));
                    continue block12;
                }
                case 2: 
                case 3: {
                    row.addColumn(new StringColumn(DataType.NUMBER, rs.getString(i)));
                    continue block12;
                }
                case 6: 
                case 7: 
                case 8: {
                    row.addColumn(new StringColumn(DataType.DOUBLE, rs.getString(i)));
                    continue block12;
                }
                case 92: {
                    row.addColumn(new StringColumn(DataType.TIME, rs.getString(i)));
                    continue block12;
                }
                case 91: {
                    row.addColumn(new TimeColumn(DataType.DATE, rs.getString(i)));
                    continue block12;
                }
                case 93: {
                    row.addColumn(new TimeColumn(DataType.TIMESTAMP, rs.getString(i)));
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    row.addColumn(new BytesColumn(DataType.BYTES, rs.getBytes(i)));
                    continue block12;
                }
                case -7: 
                case 16: {
                    row.addColumn(new StringColumn(DataType.BOOL, rs.getString(i)));
                    continue block12;
                }
                case 2005: {
                    java.sql.Clob clob;
                    if (dbType.equals((Object)DataBaseType.OCEANBASE_ORACLE_MODE)) {
                        clob = (Clob)rs.getClob(i);
                        if (clob == null) {
                            row.addColumn(new StringColumn(DataType.STRING, null));
                            continue block12;
                        }
                        row.addColumn(new StringColumn(DataType.STRING, RowUtils.clobToString((Clob)clob)));
                        continue block12;
                    }
                    clob = rs.getClob(i);
                    if (clob == null) {
                        row.addColumn(new StringColumn(DataType.STRING, null));
                        continue block12;
                    }
                    row.addColumn(new StringColumn(DataType.STRING, RowUtils.clobToString(clob)));
                    continue block12;
                }
                default: {
                    throw new RuntimeException(String.format("unknown type %s, idx = %d", metaData.getColumnType(i), i));
                }
            }
        }
        return row;
    }

    private static String clobToString(Clob data) {
        StringBuilder sb = new StringBuilder();
        try {
            int charInt;
            Reader reader = data.getCharacterStream();
            BufferedReader br = new BufferedReader(reader);
            while (-1 != (charInt = br.read())) {
                sb.append((char)charInt);
            }
            br.close();
        }
        catch (IOException e) {
            throw new DefinedException(ErrorType.SQL_EXCEPTION, String.format("IO Exception, when read clob data,cause %s", e));
        }
        return sb.toString();
    }

    private static String clobToString(java.sql.Clob data) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            Reader reader = data.getCharacterStream();
            BufferedReader br = new BufferedReader(reader);
            while (null != (line = br.readLine())) {
                sb.append(line).append('\n');
            }
            sb.deleteCharAt(sb.length() - 1);
            br.close();
        }
        catch (SQLException e) {
            throw new DefinedException(ErrorType.SQL_EXCEPTION, String.format("SQL Exception, when read clob data,cause %s", e));
        }
        catch (IOException e) {
            throw new DefinedException(ErrorType.SQL_EXCEPTION, String.format("IO Exception, when read clob data,cause %s", e));
        }
        return sb.toString();
    }
}

