/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.DataReadHandler;
import com.oceanbase.tools.migrator.core.handler.MultiGetHandler;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.task.CheckMode;
import java.sql.SQLException;

public class DataCheckHandler {
    public static boolean check(TransRows sourceTransRows) throws SQLException {
        if (sourceTransRows.getRowCount() == 0) {
            return true;
        }
        CheckMode checkMode = sourceTransRows.getOwnerTaskMeta().getJobMeta().getCheckMode();
        DataSourceAdapter targetAdapter = sourceTransRows.getOwnerTaskMeta().getJobMeta().getTargetAdapter();
        TransRows targetTransRows = null;
        switch (checkMode) {
            case SCAN: {
                targetTransRows = DataReadHandler.scan(sourceTransRows.getOwnerTaskMeta(), sourceTransRows.getOwnerTaskMeta().getJobMeta().getTargetTableMeta().getName(), targetAdapter, sourceTransRows.getMinPrimaryKey(), sourceTransRows.getMaxPrimaryKey(), sourceTransRows.getReadRowCount(), "");
                break;
            }
            case MULTIPLE_GET: {
                targetTransRows = MultiGetHandler.multiGetTargetTransRows(sourceTransRows);
                break;
            }
            default: {
                throw new UnExpectedException("unsupported check mode, " + checkMode.toString());
            }
        }
        return sourceTransRows.isMatch(targetTransRows);
    }
}

