/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.DataReadHandler;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIteratorFactory;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReadIterator {
    private static final Logger log = LoggerFactory.getLogger(DataReadIterator.class);
    private KeyReadIterator keyReadIterator = null;
    private TaskMeta taskMeta = null;

    private DataReadIterator() {
    }

    public static DataReadIterator buildDataReadIterator(TaskMeta taskMeta) {
        DataReadIterator dataReadIterator = new DataReadIterator();
        dataReadIterator.keyReadIterator = KeyReadIteratorFactory.getKeyReadIterator(taskMeta.getJobMeta());
        dataReadIterator.keyReadIterator.setTableMeta(taskMeta.getJobMeta().getPrimaryTableMeta());
        dataReadIterator.keyReadIterator.setTableName(taskMeta.getJobMeta().getSourceTableMeta().getName());
        dataReadIterator.keyReadIterator.setPartitionName(taskMeta.getPartitionName());
        dataReadIterator.keyReadIterator.setDataSourceAdapter(taskMeta.getJobMeta().getSourceAdapter());
        dataReadIterator.keyReadIterator.setMinKey(taskMeta.getMinPrimaryKey());
        dataReadIterator.keyReadIterator.setMaxKey(taskMeta.getMaxPrimaryKey());
        dataReadIterator.keyReadIterator.setCursorKey(taskMeta.getCursorPrimaryKey());
        dataReadIterator.keyReadIterator.setBatchSize(taskMeta.getJobMeta().getReaderBatchSize());
        dataReadIterator.keyReadIterator.setPrintSqlTrace(taskMeta.getJobMeta().getNeedPrintSqlTrace());
        if (taskMeta.getJobMeta().getSourceAdapter().getDataBaseType().equals((Object)DataBaseType.ORACLE)) {
            dataReadIterator.keyReadIterator.setHintPkName();
        }
        dataReadIterator.taskMeta = taskMeta;
        return dataReadIterator;
    }

    public TransRows getNext() throws SQLException {
        TransRows transRows = null;
        while (!this.keyReadIterator.isEnd() && transRows == null) {
            CursorRange cursorRange = this.keyReadIterator.getNext();
            if (cursorRange != null) {
                transRows = DataReadHandler.scan(this.taskMeta, this.taskMeta.getJobMeta().getSourceTableMeta().getName(), this.taskMeta.getJobMeta().getSourceAdapter(), cursorRange.getLowerBound(), cursorRange.getUpperBound(), this.keyReadIterator.getBatchSize(), this.keyReadIterator.getHintPkName());
                if (transRows == null) continue;
                transRows.setCursorKey(this.keyReadIterator.getCursorKey());
                continue;
            }
            log.info(String.format("cursor range is empty, taskMeta = %s", this.taskMeta.toString()));
        }
        return transRows;
    }

    public PrimaryKey getCursorKey() {
        return this.keyReadIterator.getCursorKey();
    }

    public boolean isEnd() {
        return this.keyReadIterator.isEnd();
    }
}

