/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.handler.IHandler;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.calculator.IPartIdCalculator;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger log = LoggerFactory.getLogger(HandlerUtils.class);

    public static Object runWithRetry(IHandler handler, int retryCount, int initSleepTimeMs, int maxSleepTimeMs) throws SQLException {
        Object retObj = null;
        int sleepTimeMs = initSleepTimeMs;
        for (int i = 0; i < retryCount; ++i) {
            try {
                retObj = handler.run();
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1048) {
                    retryCount = 0;
                }
                if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"interrupt")) {
                    log.warn("InterruptedException comes", (Throwable)e);
                    throw e;
                }
                if (i >= retryCount - 1) {
                    log.warn("exception comes, this is the last round", (Throwable)e);
                    throw e;
                }
                log.warn(String.format("exception comes, will retry, %d/%d", i + 1, retryCount), (Throwable)e);
                log.info(String.format("will sleep for %d ms", sleepTimeMs));
                try {
                    Thread.sleep(sleepTimeMs);
                }
                catch (InterruptedException e2) {
                    log.info("interrupted", (Throwable)e2);
                    retryCount = 0;
                }
                sleepTimeMs = Math.min(sleepTimeMs * 2, maxSleepTimeMs);
                continue;
            }
        }
        return retObj;
    }

    public static Object runWithRetry(IHandler handler) throws SQLException {
        int retryCount = 10;
        int initSleepTimeMs = 1000;
        int maxSleepTimeMs = 10000;
        return HandlerUtils.runWithRetry(handler, retryCount, initSleepTimeMs, maxSleepTimeMs);
    }

    public static Object runWithSimpleRetry(IHandler handler) throws SQLException {
        int retryCount = 2;
        int initSleepTimeMs = 500;
        int maxSleepTimeMs = 1000;
        return HandlerUtils.runWithRetry(handler, retryCount, initSleepTimeMs, maxSleepTimeMs);
    }

    public static Object runWithoutRetry(IHandler handler) throws SQLException {
        int retryCount = 1;
        int initSleepTimeMs = 500;
        int maxSleepTimeMs = 1000;
        return HandlerUtils.runWithRetry(handler, retryCount, initSleepTimeMs, maxSleepTimeMs);
    }

    public static Map<Long, BatchRows> groupBatchRowByPartition(BatchRows batchRows, String phyTableName, DataSourceAdapter dataSourceAdapter) throws SQLException {
        IPartIdCalculator obPartitionIdCalculator = dataSourceAdapter.getPartitionIdCalculator(phyTableName);
        if (obPartitionIdCalculator == null) {
            HashMap<Long, BatchRows> batchRowsMap = new HashMap<Long, BatchRows>(1);
            batchRowsMap.putIfAbsent(1L, batchRows);
            return batchRowsMap;
        }
        HashMap<Long, BatchRows> batchRowsMap = new HashMap<Long, BatchRows>(20);
        for (Row row : batchRows.getRows()) {
            BatchRows groupedBatchRow;
            Object[] record = row.getColumnList().stream().map(Column::getValue).toArray();
            Long partId = obPartitionIdCalculator.calculate(record);
            if (partId == null) {
                log.warn("failed to calculate partition id, row = %s" + row.toString());
                partId = -1L;
            }
            if ((groupedBatchRow = (BatchRows)batchRowsMap.get(partId)) != null) {
                groupedBatchRow.addRow(row);
                continue;
            }
            groupedBatchRow = new BatchRows();
            groupedBatchRow.setTableMeta(batchRows.getTableMeta());
            groupedBatchRow.setOwnerTransRows(batchRows.getOwnerTransRows());
            groupedBatchRow.addRow(row);
            batchRowsMap.put(partId, groupedBatchRow);
        }
        return batchRowsMap;
    }
}

