/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.configure.JoinTableInfo;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.handler.MultiGetHandler;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGetJoinHandler {
    private static final Logger log = LoggerFactory.getLogger(MultiGetJoinHandler.class);

    public static BatchRows multiGetJoinBatchRows(Connection connection, BatchRows primaryTableBatchRows, JoinTableInfo joinTableInfo) throws SQLException {
        BatchRows batchRows = null;
        JobMeta jobMeta = primaryTableBatchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta();
        TableMeta primaryTableMeta = primaryTableBatchRows.getTableMeta();
        TableMeta rightTableMeta = jobMeta.getSourceTableMeta(joinTableInfo.getTableName());
        int batchSize = jobMeta.getLogicTableConfig().getMultigetBatchSize();
        if (!joinTableInfo.getJoinColumn().contains("@")) {
            List<ColumnMeta> multiGetKeyColumnMetas = MultiGetJoinHandler.buildMultiGetColumnMetas(primaryTableMeta, joinTableInfo);
            String preparedJoinTableSql = MultiGetJoinHandler.getPreparedMultiGetJoinSql(rightTableMeta, multiGetKeyColumnMetas, joinTableInfo, batchSize);
            if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
                log.info(String.format("preparedJoinTableSql = %s", preparedJoinTableSql));
            }
            batchRows = MultiGetHandler.getBatchRowsWithMultiget(connection, preparedJoinTableSql, primaryTableBatchRows, multiGetKeyColumnMetas, batchSize);
        } else {
            List<ColumnMeta> lMultiGetKeyColumnMetas = MultiGetJoinHandler.buildMultiGetColumnMetas(primaryTableMeta, joinTableInfo);
            List<ColumnMeta> rMultiGetKeyColumnMetas = MultiGetJoinHandler.buildRightMultiGetColumnMetas(rightTableMeta, joinTableInfo);
            String preparedJoinTableSql = MultiGetJoinHandler.getPreparedMultiGetJoinSql(rightTableMeta, rMultiGetKeyColumnMetas, joinTableInfo, batchSize);
            if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
                log.info(String.format("preparedJoinTableSql = %s", preparedJoinTableSql));
            }
            batchRows = MultiGetHandler.getBatchRowsWithMultiget(connection, preparedJoinTableSql, primaryTableBatchRows, lMultiGetKeyColumnMetas, batchSize);
        }
        if (batchRows != null) {
            batchRows.setTableMeta(rightTableMeta);
            batchRows.setScanRowCount(primaryTableBatchRows.getRowCount());
        }
        return batchRows;
    }

    private static List<ColumnMeta> buildMultiGetColumnMetas(TableMeta primaryTableMeta, JoinTableInfo joinTableInfo) {
        if (joinTableInfo.getJoinColumn().length() == 0) {
            throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "joinColumn length should not be 0");
        }
        String[] columnNames = joinTableInfo.getJoinColumn().split(",");
        ArrayList<ColumnMeta> multiGetColumns = new ArrayList<ColumnMeta>(columnNames.length);
        if (joinTableInfo.getJoinColumn().contains("@")) {
            block0: for (String columnName : columnNames) {
                if (columnName.contains("@")) {
                    String[] columnPair = columnName.trim().split("@");
                    if (columnPair.length != 2) {
                        throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "unexpected AssociatedKey contains '@' : " + columnName);
                    }
                    for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                        if (!columnMeta.getName().equalsIgnoreCase(columnPair[0].trim())) continue;
                        multiGetColumns.add(columnMeta);
                        continue block0;
                    }
                    continue;
                }
                for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                    multiGetColumns.add(columnMeta);
                    continue block0;
                }
            }
        } else {
            for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                for (String columnName : columnNames) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                    multiGetColumns.add(columnMeta);
                }
            }
        }
        if (multiGetColumns.size() == 0) {
            throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "joinColumn size should not be 0");
        }
        return multiGetColumns;
    }

    private static List<ColumnMeta> buildRightMultiGetColumnMetas(TableMeta rightTableMeta, JoinTableInfo joinTableInfo) {
        if (joinTableInfo.getJoinColumn().trim().length() == 0) {
            throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "joinColumn length should not be 0");
        }
        String[] columnNames = joinTableInfo.getJoinColumn().split(",");
        ArrayList<ColumnMeta> rightTableKeyColumn = new ArrayList<ColumnMeta>();
        block0: for (String columnName : columnNames) {
            if (columnName.contains("@")) {
                String[] columnPair = columnName.trim().split("@");
                if (columnPair.length != 2) {
                    throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "unexpected AssociatedKey contains '@' : " + columnName);
                }
                for (ColumnMeta columnMeta : rightTableMeta.getColumnMetas()) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnPair[1])) continue;
                    rightTableKeyColumn.add(columnMeta);
                    continue block0;
                }
                continue;
            }
            for (ColumnMeta columnMeta : rightTableMeta.getColumnMetas()) {
                if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                rightTableKeyColumn.add(columnMeta);
                continue block0;
            }
        }
        return rightTableKeyColumn;
    }

    private static String getPreparedMultiGetJoinSql(TableMeta joinTableMeta, List<ColumnMeta> multiGetKeyColumnMetas, JoinTableInfo joinTableInfo, int batchSize) {
        AbstractSqlBuilder builder = SqlBuilderFactory.getSqlBuilder(joinTableMeta.getDataBaseType());
        builder.setSelectColumns(joinTableMeta.getColumnListStr());
        builder.addPrimaryKeyCondition(SqlUtils.getMultiGetCondition(multiGetKeyColumnMetas, batchSize));
        builder.addUserDefinedCondition(joinTableInfo.getWhereCond());
        builder.setTableName(joinTableMeta.getName());
        builder.setOrderByColumns(joinTableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        return builder.getReadDataSql();
    }
}

