/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.TenantMeta;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantMetaHandle {
    private static final Logger log = LoggerFactory.getLogger(TenantMetaHandle.class);
    private static final String GET_TENANT_INFO = "SELECT tenant_name, cluster_name, read_used_quota, write_used_quota, read_size_limit, write_size_limit, is_limit FROM history_tenant WHERE tenant_name = ?";

    public static TenantMeta getTenantMeta(final String tenantName) throws SQLException {
        return (TenantMeta)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(MainFramework.getMetaDataSource()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(Connection connection) throws SQLException {
                TenantMeta ret = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement(TenantMetaHandle.GET_TENANT_INFO);
                    preparedStatement.setString(1, tenantName);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        TenantMeta tenantMeta = new TenantMeta();
                        tenantMeta.setTenantName(tenantName);
                        tenantMeta.setClusterName(resultSet.getString("cluster_name"));
                        tenantMeta.setReadUsedQuota(resultSet.getLong("read_used_quota"));
                        tenantMeta.setWriteUsedQuota(resultSet.getLong("write_used_quota"));
                        tenantMeta.setReadSizeLimit(resultSet.getLong("read_size_limit"));
                        tenantMeta.setWriteSizeLimit(resultSet.getLong("write_size_limit"));
                        tenantMeta.setLimit(resultSet.getBoolean("is_limit"));
                        ret = tenantMeta;
                    }
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly(preparedStatement);
                    throw throwable;
                }
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(preparedStatement);
                return ret;
            }
        });
    }
}

