/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.DataReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyReadIterator {
    private static final Logger log = LoggerFactory.getLogger(KeyReadIterator.class);
    protected DataSourceAdapter dataSourceAdapter = null;
    protected TableMeta tableMeta = null;
    protected String tableName = "";
    protected PrimaryKey minKey = null;
    protected PrimaryKey maxKey = null;
    protected int batchSize = 200;
    protected boolean printSqlTrace = false;
    protected String hintPkName = "";
    protected String partitionName = "";
    private PrimaryKey lastUpperBound = null;
    private boolean isEnd = false;
    private String userDefinedCondition = null;

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    public void reuse() {
        this.resetIsEnd();
        this.resetLastUpperBound();
    }

    public void resetIsEnd() {
        this.isEnd = false;
    }

    public void resetLastUpperBound() {
        this.lastUpperBound = null;
    }

    public PrimaryKey getCursorKey() {
        return this.lastUpperBound;
    }

    public void setCursorKey(PrimaryKey cursorKey) {
        this.lastUpperBound = cursorKey;
    }

    private PrimaryKey getBound(String sql) throws SQLException {
        if (sql == null || sql.length() <= 0) {
            return null;
        }
        PrimaryKey bound = null;
        try (Connection connection = this.dataSourceAdapter.getConnectionReadOnly();){
            BatchRows batchRows = DataReadHandler.getBatchRows(connection, sql, this.dataSourceAdapter.getDataBaseType());
            if (batchRows == null || batchRows.getRowCount() == 0) {
                bound = null;
            } else {
                Row row = batchRows.getRows().get(0);
                bound = new PrimaryKey();
                for (int i = 0; i < this.tableMeta.getPrimaryKeyCount(); ++i) {
                    bound.addKeyColumn(row.getColumnList().get(i));
                }
            }
        }
        return bound;
    }

    public CursorRange getNext() throws SQLException {
        return (CursorRange)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(this.dataSourceAdapter){

            @Override
            public Object run(Connection connection) throws SQLException {
                CursorRange cursorRange = new CursorRange();
                PrimaryKey lowerBound = null;
                PrimaryKey upperBound = null;
                if (KeyReadIterator.this.lastUpperBound == null) {
                    if (KeyReadIterator.this.printSqlTrace) {
                        log.info(String.format("getMinBoundSql = %s", KeyReadIterator.this.getMinBoundSql()));
                    }
                    lowerBound = KeyReadIterator.this.getBound(KeyReadIterator.this.getMinBoundSql());
                } else {
                    lowerBound = new PrimaryKey(KeyReadIterator.this.lastUpperBound);
                    lowerBound.setIncluded(false);
                }
                if (lowerBound == null) {
                    KeyReadIterator.this.isEnd = true;
                    return null;
                }
                if (KeyReadIterator.this.printSqlTrace) {
                    log.info(String.format("getUpperBoundSql = %s", KeyReadIterator.this.getUpperBoundSql(lowerBound)));
                }
                if ((upperBound = KeyReadIterator.this.getBound(KeyReadIterator.this.getUpperBoundSql(lowerBound))) == null) {
                    if (KeyReadIterator.this.printSqlTrace) {
                        log.info(String.format("getMaxBoundSql = %s", KeyReadIterator.this.getMaxBoundSql(lowerBound)));
                    }
                    upperBound = KeyReadIterator.this.getBound(KeyReadIterator.this.getMaxBoundSql(lowerBound));
                    KeyReadIterator.this.isEnd = true;
                }
                if (upperBound == null) {
                    KeyReadIterator.this.isEnd = true;
                    return null;
                }
                cursorRange.setLowerBound(lowerBound);
                cursorRange.setUpperBound(upperBound);
                KeyReadIterator.this.lastUpperBound = upperBound;
                return cursorRange;
            }
        });
    }

    public void setHintPkName() {
        try {
            if (this.printSqlTrace) {
                log.info("setHintPkName");
            }
            this.getPrimaryKeyName();
        }
        catch (SQLException e) {
            log.error("failed to get oracle primary name");
        }
    }

    protected void getPrimaryKeyName() throws SQLException {
    }

    public String getHintPkName() {
        return this.hintPkName;
    }

    public String getUserDefinedCondition() {
        return this.userDefinedCondition;
    }

    public void setUserDefinedCondition(String userDefinedCondition) {
        this.userDefinedCondition = userDefinedCondition;
    }

    public void setDataSourceAdapter(DataSourceAdapter dataSourceAdapter) {
        this.dataSourceAdapter = dataSourceAdapter;
    }

    public void setTableMeta(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public void setMinKey(PrimaryKey minKey) {
        this.minKey = minKey;
    }

    public void setMaxKey(PrimaryKey maxKey) {
        this.maxKey = maxKey;
    }

    public void setLastUpperBound(PrimaryKey primaryKey) {
        this.lastUpperBound = primaryKey;
    }

    public void setPrintSqlTrace(boolean printSqlTrace) {
        this.printSqlTrace = printSqlTrace;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public abstract String getMinBoundSql();

    public abstract String getMaxBoundSql(PrimaryKey var1);

    public abstract String getUpperBoundSql(PrimaryKey var1);
}

