/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.MysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.MySqlUtils;

public class MysqlKeyReadIterator
extends KeyReadIterator {
    @Override
    public String getMinBoundSql() {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.tableMeta, this.minKey));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setLimit(1);
        return builder.getSplitSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.tableMeta, lowerBound));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.DESC);
        builder.setLimit(1);
        return builder.getSplitSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.tableMeta, lowerBound));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setOffset(this.batchSize - 1);
        builder.setLimit(1);
        return builder.getSplitSql();
    }
}

